<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for villeInput StructType
 * @subpackage Structs
 */
class VilleInput extends AbstractStructBase
{
    /**
     * The PYCPAY
     * @var int
     */
    public $PYCPAY;
    /**
     * The VICVIL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $VICVIL;
    /**
     * The VINOMV
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VINOMV;
    /**
     * Constructor method for villeInput
     * @uses VilleInput::setPYCPAY()
     * @uses VilleInput::setVICVIL()
     * @uses VilleInput::setVINOMV()
     * @param int $pYCPAY
     * @param float $vICVIL
     * @param string $vINOMV
     */
    public function __construct($pYCPAY = null, $vICVIL = null, $vINOMV = null)
    {
        $this
            ->setPYCPAY($pYCPAY)
            ->setVICVIL($vICVIL)
            ->setVINOMV($vINOMV);
    }
    /**
     * Get PYCPAY value
     * @return int|null
     */
    public function getPYCPAY()
    {
        return $this->PYCPAY;
    }
    /**
     * Set PYCPAY value
     * @param int $pYCPAY
     * @return \StructType\VilleInput
     */
    public function setPYCPAY($pYCPAY = null)
    {
        // validation for constraint: int
        if (!is_null($pYCPAY) && !is_numeric($pYCPAY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pYCPAY)), __LINE__);
        }
        $this->PYCPAY = $pYCPAY;
        return $this;
    }
    /**
     * Get VICVIL value
     * @return float|null
     */
    public function getVICVIL()
    {
        return $this->VICVIL;
    }
    /**
     * Set VICVIL value
     * @param float $vICVIL
     * @return \StructType\VilleInput
     */
    public function setVICVIL($vICVIL = null)
    {
        $this->VICVIL = $vICVIL;
        return $this;
    }
    /**
     * Get VINOMV value
     * @return string|null
     */
    public function getVINOMV()
    {
        return $this->VINOMV;
    }
    /**
     * Set VINOMV value
     * @param string $vINOMV
     * @return \StructType\VilleInput
     */
    public function setVINOMV($vINOMV = null)
    {
        // validation for constraint: string
        if (!is_null($vINOMV) && !is_string($vINOMV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vINOMV)), __LINE__);
        }
        $this->VINOMV = $vINOMV;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VilleInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
