<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Enregistrer ServiceType
 */
$enregistrer = new \ServiceType\Enregistrer($options);
/**
 * Sample call for enregistrerDossier operation/method
 */
if ($enregistrer->enregistrerDossier(new \StructType\EnregistrerDossier()) !== false) {
    print_r($enregistrer->getResult());
} else {
    print_r($enregistrer->getLastError());
}
/**
 * Samples for Modifier ServiceType
 */
$modifier = new \ServiceType\Modifier($options);
/**
 * Sample call for modifierDossier operation/method
 */
if ($modifier->modifierDossier(new \StructType\ModifierDossier()) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Samples for Valider ServiceType
 */
$valider = new \ServiceType\Valider($options);
/**
 * Sample call for validerDossier operation/method
 */
if ($valider->validerDossier(new \StructType\ValiderDossier()) !== false) {
    print_r($valider->getResult());
} else {
    print_r($valider->getLastError());
}
