<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for risqueInput StructType
 * @subpackage Structs
 */
class RisqueInput extends AbstractStructBase
{
    /**
     * The RICOUV
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RICOUV;
    /**
     * The RIDTCO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RIDTCO;
    /**
     * The VSCCIE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $VSCCIE;
    /**
     * Constructor method for risqueInput
     * @uses RisqueInput::setRICOUV()
     * @uses RisqueInput::setRIDTCO()
     * @uses RisqueInput::setVSCCIE()
     * @param string $rICOUV
     * @param float $rIDTCO
     * @param float $vSCCIE
     */
    public function __construct($rICOUV = null, $rIDTCO = null, $vSCCIE = null)
    {
        $this
            ->setRICOUV($rICOUV)
            ->setRIDTCO($rIDTCO)
            ->setVSCCIE($vSCCIE);
    }
    /**
     * Get RICOUV value
     * @return string|null
     */
    public function getRICOUV()
    {
        return $this->RICOUV;
    }
    /**
     * Set RICOUV value
     * @param string $rICOUV
     * @return \StructType\RisqueInput
     */
    public function setRICOUV($rICOUV = null)
    {
        // validation for constraint: string
        if (!is_null($rICOUV) && !is_string($rICOUV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rICOUV)), __LINE__);
        }
        $this->RICOUV = $rICOUV;
        return $this;
    }
    /**
     * Get RIDTCO value
     * @return float|null
     */
    public function getRIDTCO()
    {
        return $this->RIDTCO;
    }
    /**
     * Set RIDTCO value
     * @param float $rIDTCO
     * @return \StructType\RisqueInput
     */
    public function setRIDTCO($rIDTCO = null)
    {
        $this->RIDTCO = $rIDTCO;
        return $this;
    }
    /**
     * Get VSCCIE value
     * @return float|null
     */
    public function getVSCCIE()
    {
        return $this->VSCCIE;
    }
    /**
     * Set VSCCIE value
     * @param float $vSCCIE
     * @return \StructType\RisqueInput
     */
    public function setVSCCIE($vSCCIE = null)
    {
        $this->VSCCIE = $vSCCIE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RisqueInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
