<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateRacunFromWebResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateRacunFromWebResponse
 * @subpackage Structs
 */
class CreateRacunFromWebResponse extends ResponseBase
{
    /**
     * The CreateRacunFromWebResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CreateRacunFromWebResponse
     */
    public $CreateRacunFromWebResult;
    /**
     * The BrojRacuna
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BrojRacuna;
    /**
     * The EmailPolaznika
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailPolaznika;
    /**
     * The PdfRacuna
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PdfRacuna;
    /**
     * The RacunId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RacunId;
    /**
     * Constructor method for CreateRacunFromWebResponse
     * @uses CreateRacunFromWebResponse::setCreateRacunFromWebResult()
     * @uses CreateRacunFromWebResponse::setBrojRacuna()
     * @uses CreateRacunFromWebResponse::setEmailPolaznika()
     * @uses CreateRacunFromWebResponse::setPdfRacuna()
     * @uses CreateRacunFromWebResponse::setRacunId()
     * @param \StructType\CreateRacunFromWebResponse $createRacunFromWebResult
     * @param string $brojRacuna
     * @param string $emailPolaznika
     * @param string $pdfRacuna
     * @param string $racunId
     */
    public function __construct(\StructType\CreateRacunFromWebResponse $createRacunFromWebResult = null, $brojRacuna = null, $emailPolaznika = null, $pdfRacuna = null, $racunId = null)
    {
        $this
            ->setCreateRacunFromWebResult($createRacunFromWebResult)
            ->setBrojRacuna($brojRacuna)
            ->setEmailPolaznika($emailPolaznika)
            ->setPdfRacuna($pdfRacuna)
            ->setRacunId($racunId);
    }
    /**
     * Get CreateRacunFromWebResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CreateRacunFromWebResponse|null
     */
    public function getCreateRacunFromWebResult()
    {
        return isset($this->CreateRacunFromWebResult) ? $this->CreateRacunFromWebResult : null;
    }
    /**
     * Set CreateRacunFromWebResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CreateRacunFromWebResponse $createRacunFromWebResult
     * @return \StructType\CreateRacunFromWebResponse
     */
    public function setCreateRacunFromWebResult(\StructType\CreateRacunFromWebResponse $createRacunFromWebResult = null)
    {
        if (is_null($createRacunFromWebResult) || (is_array($createRacunFromWebResult) && empty($createRacunFromWebResult))) {
            unset($this->CreateRacunFromWebResult);
        } else {
            $this->CreateRacunFromWebResult = $createRacunFromWebResult;
        }
        return $this;
    }
    /**
     * Get BrojRacuna value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBrojRacuna()
    {
        return isset($this->BrojRacuna) ? $this->BrojRacuna : null;
    }
    /**
     * Set BrojRacuna value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $brojRacuna
     * @return \StructType\CreateRacunFromWebResponse
     */
    public function setBrojRacuna($brojRacuna = null)
    {
        // validation for constraint: string
        if (!is_null($brojRacuna) && !is_string($brojRacuna)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brojRacuna)), __LINE__);
        }
        if (is_null($brojRacuna) || (is_array($brojRacuna) && empty($brojRacuna))) {
            unset($this->BrojRacuna);
        } else {
            $this->BrojRacuna = $brojRacuna;
        }
        return $this;
    }
    /**
     * Get EmailPolaznika value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailPolaznika()
    {
        return isset($this->EmailPolaznika) ? $this->EmailPolaznika : null;
    }
    /**
     * Set EmailPolaznika value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailPolaznika
     * @return \StructType\CreateRacunFromWebResponse
     */
    public function setEmailPolaznika($emailPolaznika = null)
    {
        // validation for constraint: string
        if (!is_null($emailPolaznika) && !is_string($emailPolaznika)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailPolaznika)), __LINE__);
        }
        if (is_null($emailPolaznika) || (is_array($emailPolaznika) && empty($emailPolaznika))) {
            unset($this->EmailPolaznika);
        } else {
            $this->EmailPolaznika = $emailPolaznika;
        }
        return $this;
    }
    /**
     * Get PdfRacuna value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPdfRacuna()
    {
        return isset($this->PdfRacuna) ? $this->PdfRacuna : null;
    }
    /**
     * Set PdfRacuna value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pdfRacuna
     * @return \StructType\CreateRacunFromWebResponse
     */
    public function setPdfRacuna($pdfRacuna = null)
    {
        // validation for constraint: string
        if (!is_null($pdfRacuna) && !is_string($pdfRacuna)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pdfRacuna)), __LINE__);
        }
        if (is_null($pdfRacuna) || (is_array($pdfRacuna) && empty($pdfRacuna))) {
            unset($this->PdfRacuna);
        } else {
            $this->PdfRacuna = $pdfRacuna;
        }
        return $this;
    }
    /**
     * Get RacunId value
     * @return string|null
     */
    public function getRacunId()
    {
        return $this->RacunId;
    }
    /**
     * Set RacunId value
     * @param string $racunId
     * @return \StructType\CreateRacunFromWebResponse
     */
    public function setRacunId($racunId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($racunId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $racunId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($racunId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($racunId) && !is_string($racunId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($racunId)), __LINE__);
        }
        $this->RacunId = $racunId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateRacunFromWebResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
