<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FicheHoraire StructType
 * @subpackage Structs
 */
class FicheHoraire extends AbstractStructBase
{
    /**
     * The DebutValidite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DebutValidite;
    /**
     * The FinValidite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FinValidite;
    /**
     * The TypePeriode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TypePeriode;
    /**
     * The LibelleDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LibelleDestination;
    /**
     * The Url
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * The LibellePeriode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LibellePeriode;
    /**
     * The CodeArret
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeArret;
    /**
     * The Ligne
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ligne;
    /**
     * Constructor method for FicheHoraire
     * @uses FicheHoraire::setDebutValidite()
     * @uses FicheHoraire::setFinValidite()
     * @uses FicheHoraire::setTypePeriode()
     * @uses FicheHoraire::setLibelleDestination()
     * @uses FicheHoraire::setUrl()
     * @uses FicheHoraire::setLibellePeriode()
     * @uses FicheHoraire::setCodeArret()
     * @uses FicheHoraire::setLigne()
     * @param string $debutValidite
     * @param string $finValidite
     * @param int $typePeriode
     * @param string $libelleDestination
     * @param string $url
     * @param string $libellePeriode
     * @param string $codeArret
     * @param string $ligne
     */
    public function __construct($debutValidite = null, $finValidite = null, $typePeriode = null, $libelleDestination = null, $url = null, $libellePeriode = null, $codeArret = null, $ligne = null)
    {
        $this
            ->setDebutValidite($debutValidite)
            ->setFinValidite($finValidite)
            ->setTypePeriode($typePeriode)
            ->setLibelleDestination($libelleDestination)
            ->setUrl($url)
            ->setLibellePeriode($libellePeriode)
            ->setCodeArret($codeArret)
            ->setLigne($ligne);
    }
    /**
     * Get DebutValidite value
     * @return string
     */
    public function getDebutValidite()
    {
        return $this->DebutValidite;
    }
    /**
     * Set DebutValidite value
     * @param string $debutValidite
     * @return \StructType\FicheHoraire
     */
    public function setDebutValidite($debutValidite = null)
    {
        // validation for constraint: string
        if (!is_null($debutValidite) && !is_string($debutValidite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debutValidite)), __LINE__);
        }
        $this->DebutValidite = $debutValidite;
        return $this;
    }
    /**
     * Get FinValidite value
     * @return string
     */
    public function getFinValidite()
    {
        return $this->FinValidite;
    }
    /**
     * Set FinValidite value
     * @param string $finValidite
     * @return \StructType\FicheHoraire
     */
    public function setFinValidite($finValidite = null)
    {
        // validation for constraint: string
        if (!is_null($finValidite) && !is_string($finValidite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($finValidite)), __LINE__);
        }
        $this->FinValidite = $finValidite;
        return $this;
    }
    /**
     * Get TypePeriode value
     * @return int
     */
    public function getTypePeriode()
    {
        return $this->TypePeriode;
    }
    /**
     * Set TypePeriode value
     * @param int $typePeriode
     * @return \StructType\FicheHoraire
     */
    public function setTypePeriode($typePeriode = null)
    {
        // validation for constraint: int
        if (!is_null($typePeriode) && !is_numeric($typePeriode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($typePeriode)), __LINE__);
        }
        $this->TypePeriode = $typePeriode;
        return $this;
    }
    /**
     * Get LibelleDestination value
     * @return string|null
     */
    public function getLibelleDestination()
    {
        return $this->LibelleDestination;
    }
    /**
     * Set LibelleDestination value
     * @param string $libelleDestination
     * @return \StructType\FicheHoraire
     */
    public function setLibelleDestination($libelleDestination = null)
    {
        // validation for constraint: string
        if (!is_null($libelleDestination) && !is_string($libelleDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($libelleDestination)), __LINE__);
        }
        $this->LibelleDestination = $libelleDestination;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\FicheHoraire
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Get LibellePeriode value
     * @return string|null
     */
    public function getLibellePeriode()
    {
        return $this->LibellePeriode;
    }
    /**
     * Set LibellePeriode value
     * @param string $libellePeriode
     * @return \StructType\FicheHoraire
     */
    public function setLibellePeriode($libellePeriode = null)
    {
        // validation for constraint: string
        if (!is_null($libellePeriode) && !is_string($libellePeriode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($libellePeriode)), __LINE__);
        }
        $this->LibellePeriode = $libellePeriode;
        return $this;
    }
    /**
     * Get CodeArret value
     * @return string|null
     */
    public function getCodeArret()
    {
        return $this->CodeArret;
    }
    /**
     * Set CodeArret value
     * @param string $codeArret
     * @return \StructType\FicheHoraire
     */
    public function setCodeArret($codeArret = null)
    {
        // validation for constraint: string
        if (!is_null($codeArret) && !is_string($codeArret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeArret)), __LINE__);
        }
        $this->CodeArret = $codeArret;
        return $this;
    }
    /**
     * Get Ligne value
     * @return string|null
     */
    public function getLigne()
    {
        return $this->Ligne;
    }
    /**
     * Set Ligne value
     * @param string $ligne
     * @return \StructType\FicheHoraire
     */
    public function setLigne($ligne = null)
    {
        // validation for constraint: string
        if (!is_null($ligne) && !is_string($ligne)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ligne)), __LINE__);
        }
        $this->Ligne = $ligne;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FicheHoraire
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
