<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rechercher ServiceType
 * @subpackage Services
 */
class Rechercher extends AbstractSoapClientBase
{
    /**
     * Sets the CredentialHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\CredentialHeader $credentialHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCredentialHeader(\StructType\CredentialHeader $credentialHeader, $nameSpace = 'http://www.cts-strasbourg.fr/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CredentialHeader', $credentialHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named rechercherCodesArretsDepuisLibelle
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CredentialHeader
     * - SOAPHeaderNamespaces: http://www.cts-strasbourg.fr/
     * - SOAPHeaderTypes: \StructType\CredentialHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RechercherCodesArretsDepuisLibelle $parameters
     * @return \StructType\RechercherCodesArretsDepuisLibelleResponse|bool
     */
    public function rechercherCodesArretsDepuisLibelle(\StructType\RechercherCodesArretsDepuisLibelle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->rechercherCodesArretsDepuisLibelle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RechercherCodesArretsDepuisLibelleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
