<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFicheHoraire ArrayType
 * @subpackage Arrays
 */
class ArrayOfFicheHoraire extends AbstractStructArrayBase
{
    /**
     * The FicheHoraire
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FicheHoraire[]
     */
    public $FicheHoraire;
    /**
     * Constructor method for ArrayOfFicheHoraire
     * @uses ArrayOfFicheHoraire::setFicheHoraire()
     * @param \StructType\FicheHoraire[] $ficheHoraire
     */
    public function __construct(array $ficheHoraire = array())
    {
        $this
            ->setFicheHoraire($ficheHoraire);
    }
    /**
     * Get FicheHoraire value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FicheHoraire[]|null
     */
    public function getFicheHoraire()
    {
        return isset($this->FicheHoraire) ? $this->FicheHoraire : null;
    }
    /**
     * Set FicheHoraire value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FicheHoraire[] $ficheHoraire
     * @return \ArrayType\ArrayOfFicheHoraire
     */
    public function setFicheHoraire(array $ficheHoraire = array())
    {
        foreach ($ficheHoraire as $arrayOfFicheHoraireFicheHoraireItem) {
            // validation for constraint: itemType
            if (!$arrayOfFicheHoraireFicheHoraireItem instanceof \StructType\FicheHoraire) {
                throw new \InvalidArgumentException(sprintf('The FicheHoraire property can only contain items of \StructType\FicheHoraire, "%s" given', is_object($arrayOfFicheHoraireFicheHoraireItem) ? get_class($arrayOfFicheHoraireFicheHoraireItem) : gettype($arrayOfFicheHoraireFicheHoraireItem)), __LINE__);
            }
        }
        if (is_null($ficheHoraire) || (is_array($ficheHoraire) && empty($ficheHoraire))) {
            unset($this->FicheHoraire);
        } else {
            $this->FicheHoraire = $ficheHoraire;
        }
        return $this;
    }
    /**
     * Add item to FicheHoraire value
     * @throws \InvalidArgumentException
     * @param \StructType\FicheHoraire $item
     * @return \ArrayType\ArrayOfFicheHoraire
     */
    public function addToFicheHoraire(\StructType\FicheHoraire $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FicheHoraire) {
            throw new \InvalidArgumentException(sprintf('The FicheHoraire property can only contain items of \StructType\FicheHoraire, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FicheHoraire[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FicheHoraire|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FicheHoraire|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FicheHoraire|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FicheHoraire|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FicheHoraire|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FicheHoraire
     */
    public function getAttributeName()
    {
        return 'FicheHoraire';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfFicheHoraire
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
