<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Deviation StructType
 * @subpackage Structs
 */
class Deviation extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The Debut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Debut;
    /**
     * The Fin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Fin;
    /**
     * The Exergue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Exergue;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Position;
    /**
     * The Titre
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Titre;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Categorie
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Categorie;
    /**
     * The Lignes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Lignes;
    /**
     * Constructor method for Deviation
     * @uses Deviation::setID()
     * @uses Deviation::setDebut()
     * @uses Deviation::setFin()
     * @uses Deviation::setExergue()
     * @uses Deviation::setPosition()
     * @uses Deviation::setTitre()
     * @uses Deviation::setDescription()
     * @uses Deviation::setCategorie()
     * @uses Deviation::setLignes()
     * @param int $iD
     * @param string $debut
     * @param string $fin
     * @param bool $exergue
     * @param int $position
     * @param string $titre
     * @param string $description
     * @param string $categorie
     * @param \ArrayType\ArrayOfString $lignes
     */
    public function __construct($iD = null, $debut = null, $fin = null, $exergue = null, $position = null, $titre = null, $description = null, $categorie = null, \ArrayType\ArrayOfString $lignes = null)
    {
        $this
            ->setID($iD)
            ->setDebut($debut)
            ->setFin($fin)
            ->setExergue($exergue)
            ->setPosition($position)
            ->setTitre($titre)
            ->setDescription($description)
            ->setCategorie($categorie)
            ->setLignes($lignes);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Deviation
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Debut value
     * @return string
     */
    public function getDebut()
    {
        return $this->Debut;
    }
    /**
     * Set Debut value
     * @param string $debut
     * @return \StructType\Deviation
     */
    public function setDebut($debut = null)
    {
        // validation for constraint: string
        if (!is_null($debut) && !is_string($debut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debut)), __LINE__);
        }
        $this->Debut = $debut;
        return $this;
    }
    /**
     * Get Fin value
     * @return string
     */
    public function getFin()
    {
        return $this->Fin;
    }
    /**
     * Set Fin value
     * @param string $fin
     * @return \StructType\Deviation
     */
    public function setFin($fin = null)
    {
        // validation for constraint: string
        if (!is_null($fin) && !is_string($fin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fin)), __LINE__);
        }
        $this->Fin = $fin;
        return $this;
    }
    /**
     * Get Exergue value
     * @return bool
     */
    public function getExergue()
    {
        return $this->Exergue;
    }
    /**
     * Set Exergue value
     * @param bool $exergue
     * @return \StructType\Deviation
     */
    public function setExergue($exergue = null)
    {
        // validation for constraint: boolean
        if (!is_null($exergue) && !is_bool($exergue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($exergue)), __LINE__);
        }
        $this->Exergue = $exergue;
        return $this;
    }
    /**
     * Get Position value
     * @return int
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param int $position
     * @return \StructType\Deviation
     */
    public function setPosition($position = null)
    {
        // validation for constraint: int
        if (!is_null($position) && !is_numeric($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Titre value
     * @return string|null
     */
    public function getTitre()
    {
        return $this->Titre;
    }
    /**
     * Set Titre value
     * @param string $titre
     * @return \StructType\Deviation
     */
    public function setTitre($titre = null)
    {
        // validation for constraint: string
        if (!is_null($titre) && !is_string($titre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($titre)), __LINE__);
        }
        $this->Titre = $titre;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Deviation
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Categorie value
     * @return string|null
     */
    public function getCategorie()
    {
        return $this->Categorie;
    }
    /**
     * Set Categorie value
     * @param string $categorie
     * @return \StructType\Deviation
     */
    public function setCategorie($categorie = null)
    {
        // validation for constraint: string
        if (!is_null($categorie) && !is_string($categorie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categorie)), __LINE__);
        }
        $this->Categorie = $categorie;
        return $this;
    }
    /**
     * Get Lignes value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getLignes()
    {
        return $this->Lignes;
    }
    /**
     * Set Lignes value
     * @param \ArrayType\ArrayOfString $lignes
     * @return \StructType\Deviation
     */
    public function setLignes(\ArrayType\ArrayOfString $lignes = null)
    {
        $this->Lignes = $lignes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Deviation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
