<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInfoTrafic ArrayType
 * @subpackage Arrays
 */
class ArrayOfInfoTrafic extends AbstractStructArrayBase
{
    /**
     * The InfoTrafic
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InfoTrafic[]
     */
    public $InfoTrafic;
    /**
     * Constructor method for ArrayOfInfoTrafic
     * @uses ArrayOfInfoTrafic::setInfoTrafic()
     * @param \StructType\InfoTrafic[] $infoTrafic
     */
    public function __construct(array $infoTrafic = array())
    {
        $this
            ->setInfoTrafic($infoTrafic);
    }
    /**
     * Get InfoTrafic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InfoTrafic[]|null
     */
    public function getInfoTrafic()
    {
        return isset($this->InfoTrafic) ? $this->InfoTrafic : null;
    }
    /**
     * Set InfoTrafic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InfoTrafic[] $infoTrafic
     * @return \ArrayType\ArrayOfInfoTrafic
     */
    public function setInfoTrafic(array $infoTrafic = array())
    {
        foreach ($infoTrafic as $arrayOfInfoTraficInfoTraficItem) {
            // validation for constraint: itemType
            if (!$arrayOfInfoTraficInfoTraficItem instanceof \StructType\InfoTrafic) {
                throw new \InvalidArgumentException(sprintf('The InfoTrafic property can only contain items of \StructType\InfoTrafic, "%s" given', is_object($arrayOfInfoTraficInfoTraficItem) ? get_class($arrayOfInfoTraficInfoTraficItem) : gettype($arrayOfInfoTraficInfoTraficItem)), __LINE__);
            }
        }
        if (is_null($infoTrafic) || (is_array($infoTrafic) && empty($infoTrafic))) {
            unset($this->InfoTrafic);
        } else {
            $this->InfoTrafic = $infoTrafic;
        }
        return $this;
    }
    /**
     * Add item to InfoTrafic value
     * @throws \InvalidArgumentException
     * @param \StructType\InfoTrafic $item
     * @return \ArrayType\ArrayOfInfoTrafic
     */
    public function addToInfoTrafic(\StructType\InfoTrafic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InfoTrafic) {
            throw new \InvalidArgumentException(sprintf('The InfoTrafic property can only contain items of \StructType\InfoTrafic, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InfoTrafic[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InfoTrafic|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InfoTrafic|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InfoTrafic|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InfoTrafic|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InfoTrafic|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InfoTrafic
     */
    public function getAttributeName()
    {
        return 'InfoTrafic';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfInfoTrafic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
