<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeviation ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeviation extends AbstractStructArrayBase
{
    /**
     * The Deviation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Deviation[]
     */
    public $Deviation;
    /**
     * Constructor method for ArrayOfDeviation
     * @uses ArrayOfDeviation::setDeviation()
     * @param \StructType\Deviation[] $deviation
     */
    public function __construct(array $deviation = array())
    {
        $this
            ->setDeviation($deviation);
    }
    /**
     * Get Deviation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Deviation[]|null
     */
    public function getDeviation()
    {
        return isset($this->Deviation) ? $this->Deviation : null;
    }
    /**
     * Set Deviation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Deviation[] $deviation
     * @return \ArrayType\ArrayOfDeviation
     */
    public function setDeviation(array $deviation = array())
    {
        foreach ($deviation as $arrayOfDeviationDeviationItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeviationDeviationItem instanceof \StructType\Deviation) {
                throw new \InvalidArgumentException(sprintf('The Deviation property can only contain items of \StructType\Deviation, "%s" given', is_object($arrayOfDeviationDeviationItem) ? get_class($arrayOfDeviationDeviationItem) : gettype($arrayOfDeviationDeviationItem)), __LINE__);
            }
        }
        if (is_null($deviation) || (is_array($deviation) && empty($deviation))) {
            unset($this->Deviation);
        } else {
            $this->Deviation = $deviation;
        }
        return $this;
    }
    /**
     * Add item to Deviation value
     * @throws \InvalidArgumentException
     * @param \StructType\Deviation $item
     * @return \ArrayType\ArrayOfDeviation
     */
    public function addToDeviation(\StructType\Deviation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Deviation) {
            throw new \InvalidArgumentException(sprintf('The Deviation property can only contain items of \StructType\Deviation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Deviation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Deviation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Deviation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Deviation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Deviation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Deviation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Deviation
     */
    public function getAttributeName()
    {
        return 'Deviation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeviation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
