<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfArrivee ArrayType
 * @subpackage Arrays
 */
class ArrayOfArrivee extends AbstractStructArrayBase
{
    /**
     * The Arrivee
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Arrivee[]
     */
    public $Arrivee;
    /**
     * Constructor method for ArrayOfArrivee
     * @uses ArrayOfArrivee::setArrivee()
     * @param \StructType\Arrivee[] $arrivee
     */
    public function __construct(array $arrivee = array())
    {
        $this
            ->setArrivee($arrivee);
    }
    /**
     * Get Arrivee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Arrivee[]|null
     */
    public function getArrivee()
    {
        return isset($this->Arrivee) ? $this->Arrivee : null;
    }
    /**
     * Set Arrivee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Arrivee[] $arrivee
     * @return \ArrayType\ArrayOfArrivee
     */
    public function setArrivee(array $arrivee = array())
    {
        foreach ($arrivee as $arrayOfArriveeArriveeItem) {
            // validation for constraint: itemType
            if (!$arrayOfArriveeArriveeItem instanceof \StructType\Arrivee) {
                throw new \InvalidArgumentException(sprintf('The Arrivee property can only contain items of \StructType\Arrivee, "%s" given', is_object($arrayOfArriveeArriveeItem) ? get_class($arrayOfArriveeArriveeItem) : gettype($arrayOfArriveeArriveeItem)), __LINE__);
            }
        }
        if (is_null($arrivee) || (is_array($arrivee) && empty($arrivee))) {
            unset($this->Arrivee);
        } else {
            $this->Arrivee = $arrivee;
        }
        return $this;
    }
    /**
     * Add item to Arrivee value
     * @throws \InvalidArgumentException
     * @param \StructType\Arrivee $item
     * @return \ArrayType\ArrayOfArrivee
     */
    public function addToArrivee(\StructType\Arrivee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Arrivee) {
            throw new \InvalidArgumentException(sprintf('The Arrivee property can only contain items of \StructType\Arrivee, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Arrivee[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Arrivee|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Arrivee|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Arrivee|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Arrivee|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Arrivee|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Arrivee
     */
    public function getAttributeName()
    {
        return 'Arrivee';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfArrivee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
