<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://opendata.cts-strasbourg.fr/webservice_v4/Service.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://opendata.cts-strasbourg.fr/webservice_v4/Service.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Rechercher ServiceType
 */
$rechercher = new \ServiceType\Rechercher($options);
$rechercher->setSoapHeaderCredentialHeader(new \StructType\CredentialHeader());
/**
 * Sample call for rechercherCodesArretsDepuisLibelle operation/method
 */
if ($rechercher->rechercherCodesArretsDepuisLibelle(new \StructType\RechercherCodesArretsDepuisLibelle()) !== false) {
    print_r($rechercher->getResult());
} else {
    print_r($rechercher->getLastError());
}
/**
 * Samples for Recherche ServiceType
 */
$recherche = new \ServiceType\Recherche($options);
$recherche->setSoapHeaderCredentialHeader(new \StructType\CredentialHeader());
/**
 * Sample call for rechercheProchainesArriveesWeb operation/method
 */
if ($recherche->rechercheProchainesArriveesWeb(new \StructType\RechercheProchainesArriveesWeb()) !== false) {
    print_r($recherche->getResult());
} else {
    print_r($recherche->getLastError());
}
/**
 * Sample call for rechercheFichesHoraires operation/method
 */
if ($recherche->rechercheFichesHoraires(new \StructType\RechercheFichesHoraires()) !== false) {
    print_r($recherche->getResult());
} else {
    print_r($recherche->getLastError());
}
/**
 * Samples for Infos ServiceType
 */
$infos = new \ServiceType\Infos($options);
$infos->setSoapHeaderCredentialHeader(new \StructType\CredentialHeader());
/**
 * Sample call for infosTrafic operation/method
 */
if ($infos->infosTrafic(new \StructType\InfosTrafic()) !== false) {
    print_r($infos->getResult());
} else {
    print_r($infos->getLastError());
}
/**
 * Samples for Deviations ServiceType
 */
$deviations = new \ServiceType\Deviations($options);
$deviations->setSoapHeaderCredentialHeader(new \StructType\CredentialHeader());
/**
 * Sample call for deviations operation/method
 */
if ($deviations->deviations(new \StructType\Deviations()) !== false) {
    print_r($deviations->getResult());
} else {
    print_r($deviations->getLastError());
}
