<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoTrafic StructType
 * @subpackage Structs
 */
class InfoTrafic extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The Debut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Debut;
    /**
     * The Fin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Fin;
    /**
     * The Titre
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Titre;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for InfoTrafic
     * @uses InfoTrafic::setID()
     * @uses InfoTrafic::setDebut()
     * @uses InfoTrafic::setFin()
     * @uses InfoTrafic::setTitre()
     * @uses InfoTrafic::setDescription()
     * @param int $iD
     * @param string $debut
     * @param string $fin
     * @param string $titre
     * @param string $description
     */
    public function __construct($iD = null, $debut = null, $fin = null, $titre = null, $description = null)
    {
        $this
            ->setID($iD)
            ->setDebut($debut)
            ->setFin($fin)
            ->setTitre($titre)
            ->setDescription($description);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\InfoTrafic
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Debut value
     * @return string
     */
    public function getDebut()
    {
        return $this->Debut;
    }
    /**
     * Set Debut value
     * @param string $debut
     * @return \StructType\InfoTrafic
     */
    public function setDebut($debut = null)
    {
        // validation for constraint: string
        if (!is_null($debut) && !is_string($debut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debut)), __LINE__);
        }
        $this->Debut = $debut;
        return $this;
    }
    /**
     * Get Fin value
     * @return string
     */
    public function getFin()
    {
        return $this->Fin;
    }
    /**
     * Set Fin value
     * @param string $fin
     * @return \StructType\InfoTrafic
     */
    public function setFin($fin = null)
    {
        // validation for constraint: string
        if (!is_null($fin) && !is_string($fin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fin)), __LINE__);
        }
        $this->Fin = $fin;
        return $this;
    }
    /**
     * Get Titre value
     * @return string|null
     */
    public function getTitre()
    {
        return $this->Titre;
    }
    /**
     * Set Titre value
     * @param string $titre
     * @return \StructType\InfoTrafic
     */
    public function setTitre($titre = null)
    {
        // validation for constraint: string
        if (!is_null($titre) && !is_string($titre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($titre)), __LINE__);
        }
        $this->Titre = $titre;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\InfoTrafic
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InfoTrafic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
