<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WithdrawVetDocumentResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Результат заявки на аннулирование ветеринарного сертификата.
 * @subpackage Structs
 */
class WithdrawVetDocumentResponse extends ApplicationResultData
{
    /**
     * The vetDocument
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об аннулированном ветеринарном сертификате.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VetDocument
     */
    public $vetDocument;
    /**
     * The stockEntry
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об измененных версиях записей журнала продукции.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\StockEntry[]
     */
    public $stockEntry;
    /**
     * Constructor method for WithdrawVetDocumentResponse
     * @uses WithdrawVetDocumentResponse::setVetDocument()
     * @uses WithdrawVetDocumentResponse::setStockEntry()
     * @param \StructType\VetDocument $vetDocument
     * @param \StructType\StockEntry[] $stockEntry
     */
    public function __construct(\StructType\VetDocument $vetDocument = null, array $stockEntry = array())
    {
        $this
            ->setVetDocument($vetDocument)
            ->setStockEntry($stockEntry);
    }
    /**
     * Get vetDocument value
     * @return \StructType\VetDocument|null
     */
    public function getVetDocument()
    {
        return $this->vetDocument;
    }
    /**
     * Set vetDocument value
     * @param \StructType\VetDocument $vetDocument
     * @return \StructType\WithdrawVetDocumentResponse
     */
    public function setVetDocument(\StructType\VetDocument $vetDocument = null)
    {
        $this->vetDocument = $vetDocument;
        return $this;
    }
    /**
     * Get stockEntry value
     * @return \StructType\StockEntry[]|null
     */
    public function getStockEntry()
    {
        return $this->stockEntry;
    }
    /**
     * Set stockEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\StockEntry[] $stockEntry
     * @return \StructType\WithdrawVetDocumentResponse
     */
    public function setStockEntry(array $stockEntry = array())
    {
        foreach ($stockEntry as $withdrawVetDocumentResponseStockEntryItem) {
            // validation for constraint: itemType
            if (!$withdrawVetDocumentResponseStockEntryItem instanceof \StructType\StockEntry) {
                throw new \InvalidArgumentException(sprintf('The stockEntry property can only contain items of \StructType\StockEntry, "%s" given', is_object($withdrawVetDocumentResponseStockEntryItem) ? get_class($withdrawVetDocumentResponseStockEntryItem) : gettype($withdrawVetDocumentResponseStockEntryItem)), __LINE__);
            }
        }
        $this->stockEntry = $stockEntry;
        return $this;
    }
    /**
     * Add item to stockEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\StockEntry $item
     * @return \StructType\WithdrawVetDocumentResponse
     */
    public function addToStockEntry(\StructType\StockEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockEntry) {
            throw new \InvalidArgumentException(sprintf('The stockEntry property can only contain items of \StructType\StockEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockEntry[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WithdrawVetDocumentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
