<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VeterinaryEvent StructType
 * Meta informations extracted from the WSDL
 * - documentation: Некое событие или мероприятие, ассоциированное с партией продукции (или ЖЖ). Например, лабораторное исследование, ВСЭ,
 * произведенная обработка или иммунизация животного и т.д.
 * @subpackage Structs
 */
class VeterinaryEvent extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор события в разрезе записи складского журнала или вет.сертификата. Не задаётся пользователем в запросах (кроме
     * запросов на редактирование), формируется системой автоматически. | Тип, описывающий идентификатор.
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $ID;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование мероприятия. | Строковый тип с ограничением максимальной длины.
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: Тип мероприятия.
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The actualDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата события
     * - minOccurs: 0
     * @var string
     */
    public $actualDateTime;
    /**
     * The location
     * Meta informations extracted from the WSDL
     * - documentation: Место проведения мероприятия
     * - minOccurs: 0
     * @var \StructType\Location
     */
    public $location;
    /**
     * The enterprise
     * Meta informations extracted from the WSDL
     * - documentation: Место проведения мероприятия в случае, если это зарегистрированное предприятие
     * - minOccurs: 0
     * @var \StructType\Enterprise
     */
    public $enterprise;
    /**
     * The operator
     * Meta informations extracted from the WSDL
     * - documentation: Организация-оператор, осуществляющий мероприятие. Например, лаборатория (в случае лаб.исследований) или СББЖ.
     * - minOccurs: 0
     * @var \StructType\Organization
     */
    public $operator;
    /**
     * The referencedDocument
     * Meta informations extracted from the WSDL
     * - documentation: Связанный документ. Например, акт отбора пробы для лаб.исследования.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document[]
     */
    public $referencedDocument;
    /**
     * The notes
     * Meta informations extracted from the WSDL
     * - documentation: Дополнительные сведения. | Строковый тип без ограничения максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $notes;
    /**
     * Constructor method for VeterinaryEvent
     * @uses VeterinaryEvent::setID()
     * @uses VeterinaryEvent::setName()
     * @uses VeterinaryEvent::setType()
     * @uses VeterinaryEvent::setActualDateTime()
     * @uses VeterinaryEvent::setLocation()
     * @uses VeterinaryEvent::setEnterprise()
     * @uses VeterinaryEvent::setOperator()
     * @uses VeterinaryEvent::setReferencedDocument()
     * @uses VeterinaryEvent::setNotes()
     * @param string $iD
     * @param string $name
     * @param string $type
     * @param string $actualDateTime
     * @param \StructType\Location $location
     * @param \StructType\Enterprise $enterprise
     * @param \StructType\Organization $operator
     * @param \StructType\Document[] $referencedDocument
     * @param string $notes
     */
    public function __construct($iD = null, $name = null, $type = null, $actualDateTime = null, \StructType\Location $location = null, \StructType\Enterprise $enterprise = null, \StructType\Organization $operator = null, array $referencedDocument = array(), $notes = null)
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setType($type)
            ->setActualDateTime($actualDateTime)
            ->setLocation($location)
            ->setEnterprise($enterprise)
            ->setOperator($operator)
            ->setReferencedDocument($referencedDocument)
            ->setNotes($notes);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\VeterinaryEvent
     */
    public function setID($iD = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iD) && strlen($iD) > 100) || (is_array($iD) && count($iD) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($iD) ? strlen($iD) : count($iD)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\VeterinaryEvent
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\VeterinaryEventType::valueIsValid()
     * @uses \EnumType\VeterinaryEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\VeterinaryEvent
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VeterinaryEventType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\VeterinaryEventType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get actualDateTime value
     * @return string|null
     */
    public function getActualDateTime()
    {
        return $this->actualDateTime;
    }
    /**
     * Set actualDateTime value
     * @param string $actualDateTime
     * @return \StructType\VeterinaryEvent
     */
    public function setActualDateTime($actualDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($actualDateTime) && !is_string($actualDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualDateTime)), __LINE__);
        }
        $this->actualDateTime = $actualDateTime;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\Location|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\Location $location
     * @return \StructType\VeterinaryEvent
     */
    public function setLocation(\StructType\Location $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get enterprise value
     * @return \StructType\Enterprise|null
     */
    public function getEnterprise()
    {
        return $this->enterprise;
    }
    /**
     * Set enterprise value
     * @param \StructType\Enterprise $enterprise
     * @return \StructType\VeterinaryEvent
     */
    public function setEnterprise(\StructType\Enterprise $enterprise = null)
    {
        $this->enterprise = $enterprise;
        return $this;
    }
    /**
     * Get operator value
     * @return \StructType\Organization|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @param \StructType\Organization $operator
     * @return \StructType\VeterinaryEvent
     */
    public function setOperator(\StructType\Organization $operator = null)
    {
        $this->operator = $operator;
        return $this;
    }
    /**
     * Get referencedDocument value
     * @return \StructType\Document[]|null
     */
    public function getReferencedDocument()
    {
        return $this->referencedDocument;
    }
    /**
     * Set referencedDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\Document[] $referencedDocument
     * @return \StructType\VeterinaryEvent
     */
    public function setReferencedDocument(array $referencedDocument = array())
    {
        foreach ($referencedDocument as $veterinaryEventReferencedDocumentItem) {
            // validation for constraint: itemType
            if (!$veterinaryEventReferencedDocumentItem instanceof \StructType\Document) {
                throw new \InvalidArgumentException(sprintf('The referencedDocument property can only contain items of \StructType\Document, "%s" given', is_object($veterinaryEventReferencedDocumentItem) ? get_class($veterinaryEventReferencedDocumentItem) : gettype($veterinaryEventReferencedDocumentItem)), __LINE__);
            }
        }
        $this->referencedDocument = $referencedDocument;
        return $this;
    }
    /**
     * Add item to referencedDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\Document $item
     * @return \StructType\VeterinaryEvent
     */
    public function addToReferencedDocument(\StructType\Document $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document) {
            throw new \InvalidArgumentException(sprintf('The referencedDocument property can only contain items of \StructType\Document, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->referencedDocument[] = $item;
        return $this;
    }
    /**
     * Get notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->notes;
    }
    /**
     * Set notes value
     * @param string $notes
     * @return \StructType\VeterinaryEvent
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->notes = $notes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VeterinaryEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
