<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VeterinaryAuthentication StructType
 * Meta informations extracted from the WSDL
 * - documentation: Результаты осмотра/исследований партии. Заключение ветеринарного врача/специалиста.
 * @subpackage Structs
 */
class VeterinaryAuthentication extends AbstractStructBase
{
    /**
     * The purpose
     * Meta informations extracted from the WSDL
     * - documentation: Цель. Назначение груза.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Purpose
     */
    public $purpose;
    /**
     * The cargoInspected
     * Meta informations extracted from the WSDL
     * - documentation: Осуществлен контроль гос.ветврачом на соответствие требованиям.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $cargoInspected;
    /**
     * The cargoExpertized
     * Meta informations extracted from the WSDL
     * - documentation: Проводилась ли ветсанэкспертиза.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cargoExpertized;
    /**
     * The locationProsperity
     * Meta informations extracted from the WSDL
     * - documentation: Благополучие местности. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $locationProsperity;
    /**
     * The animalSpentPeriod
     * Meta informations extracted from the WSDL
     * - documentation: Нахождение животных на территории ТС.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $animalSpentPeriod;
    /**
     * The monthsSpent
     * Meta informations extracted from the WSDL
     * - documentation: Количество месяцев нахождения животных на территории ТС. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $monthsSpent;
    /**
     * The laboratoryResearch
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о проведенных лабораторных исследованиях.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LaboratoryResearchEvent[]
     */
    public $laboratoryResearch;
    /**
     * The quarantine
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о карантинировании.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\QuarantineEvent
     */
    public $quarantine;
    /**
     * The immunization
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о проведенной обработке/иммунизации животных.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AnimalMedicationEvent[]
     */
    public $immunization;
    /**
     * The veterinaryEvent
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о проведенных мероприятиях.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VeterinaryEvent[]
     */
    public $veterinaryEvent;
    /**
     * The r13nClause
     * Meta informations extracted from the WSDL
     * - documentation: Подтверждение соблюдаемых условий перемещения продукции.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RegionalizationClause[]
     */
    public $r13nClause;
    /**
     * The specialMarks
     * Meta informations extracted from the WSDL
     * - documentation: Особые отметки. | Строковый тип без ограничения максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $specialMarks;
    /**
     * Constructor method for VeterinaryAuthentication
     * @uses VeterinaryAuthentication::setPurpose()
     * @uses VeterinaryAuthentication::setCargoInspected()
     * @uses VeterinaryAuthentication::setCargoExpertized()
     * @uses VeterinaryAuthentication::setLocationProsperity()
     * @uses VeterinaryAuthentication::setAnimalSpentPeriod()
     * @uses VeterinaryAuthentication::setMonthsSpent()
     * @uses VeterinaryAuthentication::setLaboratoryResearch()
     * @uses VeterinaryAuthentication::setQuarantine()
     * @uses VeterinaryAuthentication::setImmunization()
     * @uses VeterinaryAuthentication::setVeterinaryEvent()
     * @uses VeterinaryAuthentication::setR13nClause()
     * @uses VeterinaryAuthentication::setSpecialMarks()
     * @param \StructType\Purpose $purpose
     * @param bool $cargoInspected
     * @param string $cargoExpertized
     * @param string $locationProsperity
     * @param string $animalSpentPeriod
     * @param string $monthsSpent
     * @param \StructType\LaboratoryResearchEvent[] $laboratoryResearch
     * @param \StructType\QuarantineEvent $quarantine
     * @param \StructType\AnimalMedicationEvent[] $immunization
     * @param \StructType\VeterinaryEvent[] $veterinaryEvent
     * @param \StructType\RegionalizationClause[] $r13nClause
     * @param string $specialMarks
     */
    public function __construct(\StructType\Purpose $purpose = null, $cargoInspected = null, $cargoExpertized = null, $locationProsperity = null, $animalSpentPeriod = null, $monthsSpent = null, array $laboratoryResearch = array(), \StructType\QuarantineEvent $quarantine = null, array $immunization = array(), array $veterinaryEvent = array(), array $r13nClause = array(), $specialMarks = null)
    {
        $this
            ->setPurpose($purpose)
            ->setCargoInspected($cargoInspected)
            ->setCargoExpertized($cargoExpertized)
            ->setLocationProsperity($locationProsperity)
            ->setAnimalSpentPeriod($animalSpentPeriod)
            ->setMonthsSpent($monthsSpent)
            ->setLaboratoryResearch($laboratoryResearch)
            ->setQuarantine($quarantine)
            ->setImmunization($immunization)
            ->setVeterinaryEvent($veterinaryEvent)
            ->setR13nClause($r13nClause)
            ->setSpecialMarks($specialMarks);
    }
    /**
     * Get purpose value
     * @return \StructType\Purpose|null
     */
    public function getPurpose()
    {
        return $this->purpose;
    }
    /**
     * Set purpose value
     * @param \StructType\Purpose $purpose
     * @return \StructType\VeterinaryAuthentication
     */
    public function setPurpose(\StructType\Purpose $purpose = null)
    {
        $this->purpose = $purpose;
        return $this;
    }
    /**
     * Get cargoInspected value
     * @return bool|null
     */
    public function getCargoInspected()
    {
        return $this->cargoInspected;
    }
    /**
     * Set cargoInspected value
     * @param bool $cargoInspected
     * @return \StructType\VeterinaryAuthentication
     */
    public function setCargoInspected($cargoInspected = null)
    {
        // validation for constraint: boolean
        if (!is_null($cargoInspected) && !is_bool($cargoInspected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($cargoInspected)), __LINE__);
        }
        $this->cargoInspected = $cargoInspected;
        return $this;
    }
    /**
     * Get cargoExpertized value
     * @return string|null
     */
    public function getCargoExpertized()
    {
        return $this->cargoExpertized;
    }
    /**
     * Set cargoExpertized value
     * @uses \EnumType\ResearchResult::valueIsValid()
     * @uses \EnumType\ResearchResult::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cargoExpertized
     * @return \StructType\VeterinaryAuthentication
     */
    public function setCargoExpertized($cargoExpertized = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ResearchResult::valueIsValid($cargoExpertized)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cargoExpertized, implode(', ', \EnumType\ResearchResult::getValidValues())), __LINE__);
        }
        $this->cargoExpertized = $cargoExpertized;
        return $this;
    }
    /**
     * Get locationProsperity value
     * @return string|null
     */
    public function getLocationProsperity()
    {
        return $this->locationProsperity;
    }
    /**
     * Set locationProsperity value
     * @param string $locationProsperity
     * @return \StructType\VeterinaryAuthentication
     */
    public function setLocationProsperity($locationProsperity = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($locationProsperity) && strlen($locationProsperity) > 255) || (is_array($locationProsperity) && count($locationProsperity) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($locationProsperity) ? strlen($locationProsperity) : count($locationProsperity)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($locationProsperity) && !is_string($locationProsperity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationProsperity)), __LINE__);
        }
        $this->locationProsperity = $locationProsperity;
        return $this;
    }
    /**
     * Get animalSpentPeriod value
     * @return string|null
     */
    public function getAnimalSpentPeriod()
    {
        return $this->animalSpentPeriod;
    }
    /**
     * Set animalSpentPeriod value
     * @uses \EnumType\AnimalSpentPeriod::valueIsValid()
     * @uses \EnumType\AnimalSpentPeriod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $animalSpentPeriod
     * @return \StructType\VeterinaryAuthentication
     */
    public function setAnimalSpentPeriod($animalSpentPeriod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AnimalSpentPeriod::valueIsValid($animalSpentPeriod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $animalSpentPeriod, implode(', ', \EnumType\AnimalSpentPeriod::getValidValues())), __LINE__);
        }
        $this->animalSpentPeriod = $animalSpentPeriod;
        return $this;
    }
    /**
     * Get monthsSpent value
     * @return string|null
     */
    public function getMonthsSpent()
    {
        return $this->monthsSpent;
    }
    /**
     * Set monthsSpent value
     * @param string $monthsSpent
     * @return \StructType\VeterinaryAuthentication
     */
    public function setMonthsSpent($monthsSpent = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($monthsSpent) && strlen($monthsSpent) > 255) || (is_array($monthsSpent) && count($monthsSpent) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($monthsSpent) ? strlen($monthsSpent) : count($monthsSpent)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($monthsSpent) && !is_string($monthsSpent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($monthsSpent)), __LINE__);
        }
        $this->monthsSpent = $monthsSpent;
        return $this;
    }
    /**
     * Get laboratoryResearch value
     * @return \StructType\LaboratoryResearchEvent[]|null
     */
    public function getLaboratoryResearch()
    {
        return $this->laboratoryResearch;
    }
    /**
     * Set laboratoryResearch value
     * @throws \InvalidArgumentException
     * @param \StructType\LaboratoryResearchEvent[] $laboratoryResearch
     * @return \StructType\VeterinaryAuthentication
     */
    public function setLaboratoryResearch(array $laboratoryResearch = array())
    {
        foreach ($laboratoryResearch as $veterinaryAuthenticationLaboratoryResearchItem) {
            // validation for constraint: itemType
            if (!$veterinaryAuthenticationLaboratoryResearchItem instanceof \StructType\LaboratoryResearchEvent) {
                throw new \InvalidArgumentException(sprintf('The laboratoryResearch property can only contain items of \StructType\LaboratoryResearchEvent, "%s" given', is_object($veterinaryAuthenticationLaboratoryResearchItem) ? get_class($veterinaryAuthenticationLaboratoryResearchItem) : gettype($veterinaryAuthenticationLaboratoryResearchItem)), __LINE__);
            }
        }
        $this->laboratoryResearch = $laboratoryResearch;
        return $this;
    }
    /**
     * Add item to laboratoryResearch value
     * @throws \InvalidArgumentException
     * @param \StructType\LaboratoryResearchEvent $item
     * @return \StructType\VeterinaryAuthentication
     */
    public function addToLaboratoryResearch(\StructType\LaboratoryResearchEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LaboratoryResearchEvent) {
            throw new \InvalidArgumentException(sprintf('The laboratoryResearch property can only contain items of \StructType\LaboratoryResearchEvent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->laboratoryResearch[] = $item;
        return $this;
    }
    /**
     * Get quarantine value
     * @return \StructType\QuarantineEvent|null
     */
    public function getQuarantine()
    {
        return $this->quarantine;
    }
    /**
     * Set quarantine value
     * @param \StructType\QuarantineEvent $quarantine
     * @return \StructType\VeterinaryAuthentication
     */
    public function setQuarantine(\StructType\QuarantineEvent $quarantine = null)
    {
        $this->quarantine = $quarantine;
        return $this;
    }
    /**
     * Get immunization value
     * @return \StructType\AnimalMedicationEvent[]|null
     */
    public function getImmunization()
    {
        return $this->immunization;
    }
    /**
     * Set immunization value
     * @throws \InvalidArgumentException
     * @param \StructType\AnimalMedicationEvent[] $immunization
     * @return \StructType\VeterinaryAuthentication
     */
    public function setImmunization(array $immunization = array())
    {
        foreach ($immunization as $veterinaryAuthenticationImmunizationItem) {
            // validation for constraint: itemType
            if (!$veterinaryAuthenticationImmunizationItem instanceof \StructType\AnimalMedicationEvent) {
                throw new \InvalidArgumentException(sprintf('The immunization property can only contain items of \StructType\AnimalMedicationEvent, "%s" given', is_object($veterinaryAuthenticationImmunizationItem) ? get_class($veterinaryAuthenticationImmunizationItem) : gettype($veterinaryAuthenticationImmunizationItem)), __LINE__);
            }
        }
        $this->immunization = $immunization;
        return $this;
    }
    /**
     * Add item to immunization value
     * @throws \InvalidArgumentException
     * @param \StructType\AnimalMedicationEvent $item
     * @return \StructType\VeterinaryAuthentication
     */
    public function addToImmunization(\StructType\AnimalMedicationEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AnimalMedicationEvent) {
            throw new \InvalidArgumentException(sprintf('The immunization property can only contain items of \StructType\AnimalMedicationEvent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->immunization[] = $item;
        return $this;
    }
    /**
     * Get veterinaryEvent value
     * @return \StructType\VeterinaryEvent[]|null
     */
    public function getVeterinaryEvent()
    {
        return $this->veterinaryEvent;
    }
    /**
     * Set veterinaryEvent value
     * @throws \InvalidArgumentException
     * @param \StructType\VeterinaryEvent[] $veterinaryEvent
     * @return \StructType\VeterinaryAuthentication
     */
    public function setVeterinaryEvent(array $veterinaryEvent = array())
    {
        foreach ($veterinaryEvent as $veterinaryAuthenticationVeterinaryEventItem) {
            // validation for constraint: itemType
            if (!$veterinaryAuthenticationVeterinaryEventItem instanceof \StructType\VeterinaryEvent) {
                throw new \InvalidArgumentException(sprintf('The veterinaryEvent property can only contain items of \StructType\VeterinaryEvent, "%s" given', is_object($veterinaryAuthenticationVeterinaryEventItem) ? get_class($veterinaryAuthenticationVeterinaryEventItem) : gettype($veterinaryAuthenticationVeterinaryEventItem)), __LINE__);
            }
        }
        $this->veterinaryEvent = $veterinaryEvent;
        return $this;
    }
    /**
     * Add item to veterinaryEvent value
     * @throws \InvalidArgumentException
     * @param \StructType\VeterinaryEvent $item
     * @return \StructType\VeterinaryAuthentication
     */
    public function addToVeterinaryEvent(\StructType\VeterinaryEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VeterinaryEvent) {
            throw new \InvalidArgumentException(sprintf('The veterinaryEvent property can only contain items of \StructType\VeterinaryEvent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->veterinaryEvent[] = $item;
        return $this;
    }
    /**
     * Get r13nClause value
     * @return \StructType\RegionalizationClause[]|null
     */
    public function getR13nClause()
    {
        return $this->r13nClause;
    }
    /**
     * Set r13nClause value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionalizationClause[] $r13nClause
     * @return \StructType\VeterinaryAuthentication
     */
    public function setR13nClause(array $r13nClause = array())
    {
        foreach ($r13nClause as $veterinaryAuthenticationR13nClauseItem) {
            // validation for constraint: itemType
            if (!$veterinaryAuthenticationR13nClauseItem instanceof \StructType\RegionalizationClause) {
                throw new \InvalidArgumentException(sprintf('The r13nClause property can only contain items of \StructType\RegionalizationClause, "%s" given', is_object($veterinaryAuthenticationR13nClauseItem) ? get_class($veterinaryAuthenticationR13nClauseItem) : gettype($veterinaryAuthenticationR13nClauseItem)), __LINE__);
            }
        }
        $this->r13nClause = $r13nClause;
        return $this;
    }
    /**
     * Add item to r13nClause value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionalizationClause $item
     * @return \StructType\VeterinaryAuthentication
     */
    public function addToR13nClause(\StructType\RegionalizationClause $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RegionalizationClause) {
            throw new \InvalidArgumentException(sprintf('The r13nClause property can only contain items of \StructType\RegionalizationClause, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->r13nClause[] = $item;
        return $this;
    }
    /**
     * Get specialMarks value
     * @return string|null
     */
    public function getSpecialMarks()
    {
        return $this->specialMarks;
    }
    /**
     * Set specialMarks value
     * @param string $specialMarks
     * @return \StructType\VeterinaryAuthentication
     */
    public function setSpecialMarks($specialMarks = null)
    {
        // validation for constraint: string
        if (!is_null($specialMarks) && !is_string($specialMarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($specialMarks)), __LINE__);
        }
        $this->specialMarks = $specialMarks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VeterinaryAuthentication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
