<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for User StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий пользователя организации/учреждения.
 * @subpackage Structs
 */
class User extends GenericEntity
{
    /**
     * The login
     * Meta informations extracted from the WSDL
     * - documentation: Имя пользователя в системе Ветис.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - documentation: Имя пользователя. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $firstName;
    /**
     * The middleName
     * Meta informations extracted from the WSDL
     * - documentation: Отчество пользователя. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $middleName;
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - documentation: Фамилия пользователя. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $lastName;
    /**
     * The fio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО пользователя. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $fio;
    /**
     * The birthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения пользователя.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $birthDate;
    /**
     * The identity
     * Meta informations extracted from the WSDL
     * - documentation: Документ, удостоверяющий личность.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Document
     */
    public $identity;
    /**
     * The citizenship
     * Meta informations extracted from the WSDL
     * - documentation: Гражданство.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Citizenship
     */
    public $citizenship;
    /**
     * The snils
     * Meta informations extracted from the WSDL
     * - documentation: СНИЛС пользователя.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{3}-[0-9]{3}-[0-9]{3} [0-9]{2}
     * @var string
     */
    public $snils;
    /**
     * The phone
     * Meta informations extracted from the WSDL
     * - documentation: Личный телефон пользователя. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $phone;
    /**
     * The workPhone
     * Meta informations extracted from the WSDL
     * - documentation: Рабочий (контактный) телефон пользователя. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $workPhone;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - documentation: Личный адрес электронной почты пользователя. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $email;
    /**
     * The workEmail
     * Meta informations extracted from the WSDL
     * - documentation: Рабочий адрес электронной почты пользователя. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $workEmail;
    /**
     * The organization
     * Meta informations extracted from the WSDL
     * - documentation: Организация пользователя.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Organization
     */
    public $organization;
    /**
     * The businessEntity
     * Meta informations extracted from the WSDL
     * - documentation: Хозяйствующий субъект пользователя.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BusinessEntity
     */
    public $businessEntity;
    /**
     * The post
     * Meta informations extracted from the WSDL
     * - documentation: Должность пользователя в организации (`organization` или `businessEntity`). | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $post;
    /**
     * The enabled
     * Meta informations extracted from the WSDL
     * - documentation: Аккаунт пользователя разрешен/активен.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $enabled;
    /**
     * The nonExpired
     * Meta informations extracted from the WSDL
     * - documentation: Аккаунт пользователя не истек (срок действия).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $nonExpired;
    /**
     * The nonLocked
     * Meta informations extracted from the WSDL
     * - documentation: Аккаунт пользователя не заблокирован.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $nonLocked;
    /**
     * The authorityList
     * Meta informations extracted from the WSDL
     * - documentation: Список ролей пользователя.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AuthorityList
     */
    public $authorityList;
    /**
     * The workingAreaList
     * Meta informations extracted from the WSDL
     * - documentation: Список зон обслуживания.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WorkingAreaList
     */
    public $workingAreaList;
    /**
     * Constructor method for User
     * @uses User::setLogin()
     * @uses User::setFirstName()
     * @uses User::setMiddleName()
     * @uses User::setLastName()
     * @uses User::setFio()
     * @uses User::setBirthDate()
     * @uses User::setIdentity()
     * @uses User::setCitizenship()
     * @uses User::setSnils()
     * @uses User::setPhone()
     * @uses User::setWorkPhone()
     * @uses User::setEmail()
     * @uses User::setWorkEmail()
     * @uses User::setOrganization()
     * @uses User::setBusinessEntity()
     * @uses User::setPost()
     * @uses User::setEnabled()
     * @uses User::setNonExpired()
     * @uses User::setNonLocked()
     * @uses User::setAuthorityList()
     * @uses User::setWorkingAreaList()
     * @param string $login
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     * @param string $fio
     * @param string $birthDate
     * @param \StructType\Document $identity
     * @param \StructType\Citizenship $citizenship
     * @param string $snils
     * @param string $phone
     * @param string $workPhone
     * @param string $email
     * @param string $workEmail
     * @param \StructType\Organization $organization
     * @param \StructType\BusinessEntity $businessEntity
     * @param string $post
     * @param bool $enabled
     * @param bool $nonExpired
     * @param bool $nonLocked
     * @param \StructType\AuthorityList $authorityList
     * @param \StructType\WorkingAreaList $workingAreaList
     */
    public function __construct($login = null, $firstName = null, $middleName = null, $lastName = null, $fio = null, $birthDate = null, \StructType\Document $identity = null, \StructType\Citizenship $citizenship = null, $snils = null, $phone = null, $workPhone = null, $email = null, $workEmail = null, \StructType\Organization $organization = null, \StructType\BusinessEntity $businessEntity = null, $post = null, $enabled = null, $nonExpired = null, $nonLocked = null, \StructType\AuthorityList $authorityList = null, \StructType\WorkingAreaList $workingAreaList = null)
    {
        $this
            ->setLogin($login)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName)
            ->setFio($fio)
            ->setBirthDate($birthDate)
            ->setIdentity($identity)
            ->setCitizenship($citizenship)
            ->setSnils($snils)
            ->setPhone($phone)
            ->setWorkPhone($workPhone)
            ->setEmail($email)
            ->setWorkEmail($workEmail)
            ->setOrganization($organization)
            ->setBusinessEntity($businessEntity)
            ->setPost($post)
            ->setEnabled($enabled)
            ->setNonExpired($nonExpired)
            ->setNonLocked($nonLocked)
            ->setAuthorityList($authorityList)
            ->setWorkingAreaList($workingAreaList);
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\User
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\User
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($firstName) && strlen($firstName) > 255) || (is_array($firstName) && count($firstName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($firstName) ? strlen($firstName) : count($firstName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \StructType\User
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($middleName) && strlen($middleName) > 255) || (is_array($middleName) && count($middleName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($middleName) ? strlen($middleName) : count($middleName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\User
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($lastName) && strlen($lastName) > 255) || (is_array($lastName) && count($lastName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($lastName) ? strlen($lastName) : count($lastName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get fio value
     * @return string|null
     */
    public function getFio()
    {
        return $this->fio;
    }
    /**
     * Set fio value
     * @param string $fio
     * @return \StructType\User
     */
    public function setFio($fio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fio) && strlen($fio) > 255) || (is_array($fio) && count($fio) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($fio) ? strlen($fio) : count($fio)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fio) && !is_string($fio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fio)), __LINE__);
        }
        $this->fio = $fio;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \StructType\User
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Get identity value
     * @return \StructType\Document|null
     */
    public function getIdentity()
    {
        return $this->identity;
    }
    /**
     * Set identity value
     * @param \StructType\Document $identity
     * @return \StructType\User
     */
    public function setIdentity(\StructType\Document $identity = null)
    {
        $this->identity = $identity;
        return $this;
    }
    /**
     * Get citizenship value
     * @return \StructType\Citizenship|null
     */
    public function getCitizenship()
    {
        return $this->citizenship;
    }
    /**
     * Set citizenship value
     * @param \StructType\Citizenship $citizenship
     * @return \StructType\User
     */
    public function setCitizenship(\StructType\Citizenship $citizenship = null)
    {
        $this->citizenship = $citizenship;
        return $this;
    }
    /**
     * Get snils value
     * @return string|null
     */
    public function getSnils()
    {
        return $this->snils;
    }
    /**
     * Set snils value
     * @param string $snils
     * @return \StructType\User
     */
    public function setSnils($snils = null)
    {
        // validation for constraint: pattern
        if (is_scalar($snils) && !preg_match('/[0-9]{3}-[0-9]{3}-[0-9]{3} [0-9]{2}/', $snils)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{3}-[0-9]{3}-[0-9]{3} [0-9]{2}", "%s" given', var_export($snils, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($snils) && !is_string($snils)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($snils)), __LINE__);
        }
        $this->snils = $snils;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\User
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($phone) && strlen($phone) > 255) || (is_array($phone) && count($phone) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($phone) ? strlen($phone) : count($phone)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get workPhone value
     * @return string|null
     */
    public function getWorkPhone()
    {
        return $this->workPhone;
    }
    /**
     * Set workPhone value
     * @param string $workPhone
     * @return \StructType\User
     */
    public function setWorkPhone($workPhone = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($workPhone) && strlen($workPhone) > 255) || (is_array($workPhone) && count($workPhone) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($workPhone) ? strlen($workPhone) : count($workPhone)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($workPhone) && !is_string($workPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workPhone)), __LINE__);
        }
        $this->workPhone = $workPhone;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\User
     */
    public function setEmail($email = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($email) && strlen($email) > 255) || (is_array($email) && count($email) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($email) ? strlen($email) : count($email)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get workEmail value
     * @return string|null
     */
    public function getWorkEmail()
    {
        return $this->workEmail;
    }
    /**
     * Set workEmail value
     * @param string $workEmail
     * @return \StructType\User
     */
    public function setWorkEmail($workEmail = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($workEmail) && strlen($workEmail) > 255) || (is_array($workEmail) && count($workEmail) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($workEmail) ? strlen($workEmail) : count($workEmail)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($workEmail) && !is_string($workEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workEmail)), __LINE__);
        }
        $this->workEmail = $workEmail;
        return $this;
    }
    /**
     * Get organization value
     * @return \StructType\Organization|null
     */
    public function getOrganization()
    {
        return $this->organization;
    }
    /**
     * Set organization value
     * @param \StructType\Organization $organization
     * @return \StructType\User
     */
    public function setOrganization(\StructType\Organization $organization = null)
    {
        $this->organization = $organization;
        return $this;
    }
    /**
     * Get businessEntity value
     * @return \StructType\BusinessEntity|null
     */
    public function getBusinessEntity()
    {
        return $this->businessEntity;
    }
    /**
     * Set businessEntity value
     * @param \StructType\BusinessEntity $businessEntity
     * @return \StructType\User
     */
    public function setBusinessEntity(\StructType\BusinessEntity $businessEntity = null)
    {
        $this->businessEntity = $businessEntity;
        return $this;
    }
    /**
     * Get post value
     * @return string|null
     */
    public function getPost()
    {
        return $this->post;
    }
    /**
     * Set post value
     * @param string $post
     * @return \StructType\User
     */
    public function setPost($post = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($post) && strlen($post) > 255) || (is_array($post) && count($post) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($post) ? strlen($post) : count($post)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($post) && !is_string($post)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($post)), __LINE__);
        }
        $this->post = $post;
        return $this;
    }
    /**
     * Get enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->enabled;
    }
    /**
     * Set enabled value
     * @param bool $enabled
     * @return \StructType\User
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enabled)), __LINE__);
        }
        $this->enabled = $enabled;
        return $this;
    }
    /**
     * Get nonExpired value
     * @return bool|null
     */
    public function getNonExpired()
    {
        return $this->nonExpired;
    }
    /**
     * Set nonExpired value
     * @param bool $nonExpired
     * @return \StructType\User
     */
    public function setNonExpired($nonExpired = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonExpired) && !is_bool($nonExpired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nonExpired)), __LINE__);
        }
        $this->nonExpired = $nonExpired;
        return $this;
    }
    /**
     * Get nonLocked value
     * @return bool|null
     */
    public function getNonLocked()
    {
        return $this->nonLocked;
    }
    /**
     * Set nonLocked value
     * @param bool $nonLocked
     * @return \StructType\User
     */
    public function setNonLocked($nonLocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonLocked) && !is_bool($nonLocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nonLocked)), __LINE__);
        }
        $this->nonLocked = $nonLocked;
        return $this;
    }
    /**
     * Get authorityList value
     * @return \StructType\AuthorityList|null
     */
    public function getAuthorityList()
    {
        return $this->authorityList;
    }
    /**
     * Set authorityList value
     * @param \StructType\AuthorityList $authorityList
     * @return \StructType\User
     */
    public function setAuthorityList(\StructType\AuthorityList $authorityList = null)
    {
        $this->authorityList = $authorityList;
        return $this;
    }
    /**
     * Get workingAreaList value
     * @return \StructType\WorkingAreaList|null
     */
    public function getWorkingAreaList()
    {
        return $this->workingAreaList;
    }
    /**
     * Set workingAreaList value
     * @param \StructType\WorkingAreaList $workingAreaList
     * @return \StructType\User
     */
    public function setWorkingAreaList(\StructType\WorkingAreaList $workingAreaList = null)
    {
        $this->workingAreaList = $workingAreaList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\User
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
