<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateTransportMovementDetailsRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявка на изменение сведений о транспортных средствах, осуществляющих доставку сертифицированной партии. Поддерживается
 * уполномоченное выполнение. | Грузополучатель или грузоотправитель, осуществляющий изменение параметров маршрута. | Идентификатор
 * транспортного вет.сертификата. Может быть указано более одного сертификата на партии, оформленные строго в одной поставк в адрес одного
 * получателя. | Маршрут следования. Указывается список точек перегрузки и сведения о транспорте. Для точки перегрузки должен быть указан
 * её идентификатор (uuid). В запросе на изменение могут участвовать только точки маршрута, для которых установлен флаг transshipment (точка
 * перегрузки).
 * @subpackage Structs
 */
class UpdateTransportMovementDetailsRequest extends MercuryApplicationRequest
{
    /**
     * The deliveryParticipant
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: vd:deliveryParticipant
     * @var \StructType\BusinessMember
     */
    public $deliveryParticipant;
    /**
     * The vetDocumentUuid
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - ref: vd:vetDocumentUuid
     * - documentation: Тип, описывающий уникальный идентификатор любой сущности системы.
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string[]
     */
    public $vetDocumentUuid;
    /**
     * The shipmentRoute
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: vd:shipmentRoute
     * @var \StructType\ShipmentRoute
     */
    public $shipmentRoute;
    /**
     * Constructor method for UpdateTransportMovementDetailsRequest
     * @uses UpdateTransportMovementDetailsRequest::setDeliveryParticipant()
     * @uses UpdateTransportMovementDetailsRequest::setVetDocumentUuid()
     * @uses UpdateTransportMovementDetailsRequest::setShipmentRoute()
     * @param \StructType\BusinessMember $deliveryParticipant
     * @param string[] $vetDocumentUuid
     * @param \StructType\ShipmentRoute $shipmentRoute
     */
    public function __construct(\StructType\BusinessMember $deliveryParticipant = null, array $vetDocumentUuid = array(), \StructType\ShipmentRoute $shipmentRoute = null)
    {
        $this
            ->setDeliveryParticipant($deliveryParticipant)
            ->setVetDocumentUuid($vetDocumentUuid)
            ->setShipmentRoute($shipmentRoute);
    }
    /**
     * Get deliveryParticipant value
     * @return \StructType\BusinessMember
     */
    public function getDeliveryParticipant()
    {
        return $this->deliveryParticipant;
    }
    /**
     * Set deliveryParticipant value
     * @param \StructType\BusinessMember $deliveryParticipant
     * @return \StructType\UpdateTransportMovementDetailsRequest
     */
    public function setDeliveryParticipant(\StructType\BusinessMember $deliveryParticipant = null)
    {
        $this->deliveryParticipant = $deliveryParticipant;
        return $this;
    }
    /**
     * Get vetDocumentUuid value
     * @return string[]
     */
    public function getVetDocumentUuid()
    {
        return $this->vetDocumentUuid;
    }
    /**
     * Set vetDocumentUuid value
     * @throws \InvalidArgumentException
     * @param string[] $vetDocumentUuid
     * @return \StructType\UpdateTransportMovementDetailsRequest
     */
    public function setVetDocumentUuid(array $vetDocumentUuid = array())
    {
        // validation for constraint: pattern
        if (is_scalar($vetDocumentUuid) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $vetDocumentUuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($vetDocumentUuid, true)), __LINE__);
        }
        foreach ($vetDocumentUuid as $updateTransportMovementDetailsRequestVetDocumentUuidItem) {
            // validation for constraint: itemType
            if (!is_string($updateTransportMovementDetailsRequestVetDocumentUuidItem)) {
                throw new \InvalidArgumentException(sprintf('The vetDocumentUuid property can only contain items of string, "%s" given', is_object($updateTransportMovementDetailsRequestVetDocumentUuidItem) ? get_class($updateTransportMovementDetailsRequestVetDocumentUuidItem) : gettype($updateTransportMovementDetailsRequestVetDocumentUuidItem)), __LINE__);
            }
        }
        $this->vetDocumentUuid = $vetDocumentUuid;
        return $this;
    }
    /**
     * Add item to vetDocumentUuid value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\UpdateTransportMovementDetailsRequest
     */
    public function addToVetDocumentUuid($item)
    {
        // validation for constraint: pattern
        if (is_scalar($item) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($item, true)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The vetDocumentUuid property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->vetDocumentUuid[] = $item;
        return $this;
    }
    /**
     * Get shipmentRoute value
     * @return \StructType\ShipmentRoute
     */
    public function getShipmentRoute()
    {
        return $this->shipmentRoute;
    }
    /**
     * Set shipmentRoute value
     * @param \StructType\ShipmentRoute $shipmentRoute
     * @return \StructType\UpdateTransportMovementDetailsRequest
     */
    public function setShipmentRoute(\StructType\ShipmentRoute $shipmentRoute = null)
    {
        $this->shipmentRoute = $shipmentRoute;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateTransportMovementDetailsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
