<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Unit StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий единицу измерения.
 * @subpackage Structs
 */
class Unit extends GenericVersioningEntity
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование единицы измерения. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The fullName
     * Meta informations extracted from the WSDL
     * - documentation: Полное наименование единицы измерения, если оно отличается от name. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $fullName;
    /**
     * The commonUnitGuid
     * Meta informations extracted from the WSDL
     * - documentation: Глобальный идентификатор базовой единицы измерения. Например, для центнера, тонны, тыс.тонн базовой единицей измерения
     * является килограмм. | Тип, описывающий уникальный идентификатор любой сущности системы.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $commonUnitGuid;
    /**
     * The factor
     * Meta informations extracted from the WSDL
     * - documentation: Коэффициент относительно базовой единицы измерения. Например, для тонны этот коэффициент равен 1000, т.к. в 1 тонне 1000 кг. Для
     * килограмма этот коэффициент равен единице.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $factor;
    /**
     * Constructor method for Unit
     * @uses Unit::setName()
     * @uses Unit::setFullName()
     * @uses Unit::setCommonUnitGuid()
     * @uses Unit::setFactor()
     * @param string $name
     * @param string $fullName
     * @param string $commonUnitGuid
     * @param int $factor
     */
    public function __construct($name = null, $fullName = null, $commonUnitGuid = null, $factor = null)
    {
        $this
            ->setName($name)
            ->setFullName($fullName)
            ->setCommonUnitGuid($commonUnitGuid)
            ->setFactor($factor);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Unit
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get fullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->fullName;
    }
    /**
     * Set fullName value
     * @param string $fullName
     * @return \StructType\Unit
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fullName) && strlen($fullName) > 255) || (is_array($fullName) && count($fullName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($fullName) ? strlen($fullName) : count($fullName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullName)), __LINE__);
        }
        $this->fullName = $fullName;
        return $this;
    }
    /**
     * Get commonUnitGuid value
     * @return string|null
     */
    public function getCommonUnitGuid()
    {
        return $this->commonUnitGuid;
    }
    /**
     * Set commonUnitGuid value
     * @param string $commonUnitGuid
     * @return \StructType\Unit
     */
    public function setCommonUnitGuid($commonUnitGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($commonUnitGuid) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $commonUnitGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($commonUnitGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($commonUnitGuid) && !is_string($commonUnitGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commonUnitGuid)), __LINE__);
        }
        $this->commonUnitGuid = $commonUnitGuid;
        return $this;
    }
    /**
     * Get factor value
     * @return int|null
     */
    public function getFactor()
    {
        return $this->factor;
    }
    /**
     * Set factor value
     * @param int $factor
     * @return \StructType\Unit
     */
    public function setFactor($factor = null)
    {
        // validation for constraint: int
        if (!is_null($factor) && !is_numeric($factor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($factor)), __LINE__);
        }
        $this->factor = $factor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Unit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
