<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportNumber StructType
 * Meta informations extracted from the WSDL
 * - documentation: Номер транспортного средства.
 * @subpackage Structs
 */
class TransportNumber extends AbstractStructBase
{
    /**
     * The containerNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер контейнера. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $containerNumber;
    /**
     * The wagonNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер авиарейса. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $wagonNumber;
    /**
     * The vehicleNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер автомобиля. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $vehicleNumber;
    /**
     * The trailerNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер прицепа (полуприцепа). | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $trailerNumber;
    /**
     * The shipName
     * Meta informations extracted from the WSDL
     * - documentation: Название судна. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $shipName;
    /**
     * The flightNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер авиарейса. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $flightNumber;
    /**
     * Constructor method for TransportNumber
     * @uses TransportNumber::setContainerNumber()
     * @uses TransportNumber::setWagonNumber()
     * @uses TransportNumber::setVehicleNumber()
     * @uses TransportNumber::setTrailerNumber()
     * @uses TransportNumber::setShipName()
     * @uses TransportNumber::setFlightNumber()
     * @param string $containerNumber
     * @param string $wagonNumber
     * @param string $vehicleNumber
     * @param string $trailerNumber
     * @param string $shipName
     * @param string $flightNumber
     */
    public function __construct($containerNumber = null, $wagonNumber = null, $vehicleNumber = null, $trailerNumber = null, $shipName = null, $flightNumber = null)
    {
        $this
            ->setContainerNumber($containerNumber)
            ->setWagonNumber($wagonNumber)
            ->setVehicleNumber($vehicleNumber)
            ->setTrailerNumber($trailerNumber)
            ->setShipName($shipName)
            ->setFlightNumber($flightNumber);
    }
    /**
     * Get containerNumber value
     * @return string|null
     */
    public function getContainerNumber()
    {
        return $this->containerNumber;
    }
    /**
     * Set containerNumber value
     * @param string $containerNumber
     * @return \StructType\TransportNumber
     */
    public function setContainerNumber($containerNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($containerNumber) && strlen($containerNumber) > 255) || (is_array($containerNumber) && count($containerNumber) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($containerNumber) ? strlen($containerNumber) : count($containerNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($containerNumber) && !is_string($containerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($containerNumber)), __LINE__);
        }
        $this->containerNumber = $containerNumber;
        return $this;
    }
    /**
     * Get wagonNumber value
     * @return string|null
     */
    public function getWagonNumber()
    {
        return $this->wagonNumber;
    }
    /**
     * Set wagonNumber value
     * @param string $wagonNumber
     * @return \StructType\TransportNumber
     */
    public function setWagonNumber($wagonNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($wagonNumber) && strlen($wagonNumber) > 255) || (is_array($wagonNumber) && count($wagonNumber) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($wagonNumber) ? strlen($wagonNumber) : count($wagonNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($wagonNumber) && !is_string($wagonNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wagonNumber)), __LINE__);
        }
        $this->wagonNumber = $wagonNumber;
        return $this;
    }
    /**
     * Get vehicleNumber value
     * @return string|null
     */
    public function getVehicleNumber()
    {
        return $this->vehicleNumber;
    }
    /**
     * Set vehicleNumber value
     * @param string $vehicleNumber
     * @return \StructType\TransportNumber
     */
    public function setVehicleNumber($vehicleNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($vehicleNumber) && strlen($vehicleNumber) > 255) || (is_array($vehicleNumber) && count($vehicleNumber) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($vehicleNumber) ? strlen($vehicleNumber) : count($vehicleNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vehicleNumber) && !is_string($vehicleNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleNumber)), __LINE__);
        }
        $this->vehicleNumber = $vehicleNumber;
        return $this;
    }
    /**
     * Get trailerNumber value
     * @return string|null
     */
    public function getTrailerNumber()
    {
        return $this->trailerNumber;
    }
    /**
     * Set trailerNumber value
     * @param string $trailerNumber
     * @return \StructType\TransportNumber
     */
    public function setTrailerNumber($trailerNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($trailerNumber) && strlen($trailerNumber) > 255) || (is_array($trailerNumber) && count($trailerNumber) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($trailerNumber) ? strlen($trailerNumber) : count($trailerNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($trailerNumber) && !is_string($trailerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trailerNumber)), __LINE__);
        }
        $this->trailerNumber = $trailerNumber;
        return $this;
    }
    /**
     * Get shipName value
     * @return string|null
     */
    public function getShipName()
    {
        return $this->shipName;
    }
    /**
     * Set shipName value
     * @param string $shipName
     * @return \StructType\TransportNumber
     */
    public function setShipName($shipName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($shipName) && strlen($shipName) > 255) || (is_array($shipName) && count($shipName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($shipName) ? strlen($shipName) : count($shipName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($shipName) && !is_string($shipName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipName)), __LINE__);
        }
        $this->shipName = $shipName;
        return $this;
    }
    /**
     * Get flightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->flightNumber;
    }
    /**
     * Set flightNumber value
     * @param string $flightNumber
     * @return \StructType\TransportNumber
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($flightNumber) && strlen($flightNumber) > 255) || (is_array($flightNumber) && count($flightNumber) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($flightNumber) ? strlen($flightNumber) : count($flightNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->flightNumber = $flightNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransportNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
