<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Street StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип улицы.
 * @subpackage Structs
 */
class Street extends AddressObjectView
{
    /**
     * The localityGuid
     * Meta informations extracted from the WSDL
     * - documentation: Глобальный идентификатор насленного пункта, к которому относится данная улица. | Тип, описывающий уникальный идентификатор
     * любой сущности системы.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $localityGuid;
    /**
     * Constructor method for Street
     * @uses Street::setLocalityGuid()
     * @param string $localityGuid
     */
    public function __construct($localityGuid = null)
    {
        $this
            ->setLocalityGuid($localityGuid);
    }
    /**
     * Get localityGuid value
     * @return string|null
     */
    public function getLocalityGuid()
    {
        return $this->localityGuid;
    }
    /**
     * Set localityGuid value
     * @param string $localityGuid
     * @return \StructType\Street
     */
    public function setLocalityGuid($localityGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($localityGuid) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $localityGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($localityGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($localityGuid) && !is_string($localityGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localityGuid)), __LINE__);
        }
        $this->localityGuid = $localityGuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Street
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
