<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockEntryEventList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Список мероприятий с партией продукции.
 * @subpackage Structs
 */
class StockEntryEventList extends AbstractStructBase
{
    /**
     * The laboratoryResearch
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о проведенных лабораторных исследованиях.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LaboratoryResearchEvent[]
     */
    public $laboratoryResearch;
    /**
     * The quarantine
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о карантинировании.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\QuarantineEvent[]
     */
    public $quarantine;
    /**
     * The immunization
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о проведенной обработке/иммунизации животных.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AnimalMedicationEvent[]
     */
    public $immunization;
    /**
     * The veterinaryEvent
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о проведенных мероприятиях.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VeterinaryEvent[]
     */
    public $veterinaryEvent;
    /**
     * Constructor method for StockEntryEventList
     * @uses StockEntryEventList::setLaboratoryResearch()
     * @uses StockEntryEventList::setQuarantine()
     * @uses StockEntryEventList::setImmunization()
     * @uses StockEntryEventList::setVeterinaryEvent()
     * @param \StructType\LaboratoryResearchEvent[] $laboratoryResearch
     * @param \StructType\QuarantineEvent[] $quarantine
     * @param \StructType\AnimalMedicationEvent[] $immunization
     * @param \StructType\VeterinaryEvent[] $veterinaryEvent
     */
    public function __construct(array $laboratoryResearch = array(), array $quarantine = array(), array $immunization = array(), array $veterinaryEvent = array())
    {
        $this
            ->setLaboratoryResearch($laboratoryResearch)
            ->setQuarantine($quarantine)
            ->setImmunization($immunization)
            ->setVeterinaryEvent($veterinaryEvent);
    }
    /**
     * Get laboratoryResearch value
     * @return \StructType\LaboratoryResearchEvent[]|null
     */
    public function getLaboratoryResearch()
    {
        return $this->laboratoryResearch;
    }
    /**
     * Set laboratoryResearch value
     * @throws \InvalidArgumentException
     * @param \StructType\LaboratoryResearchEvent[] $laboratoryResearch
     * @return \StructType\StockEntryEventList
     */
    public function setLaboratoryResearch(array $laboratoryResearch = array())
    {
        foreach ($laboratoryResearch as $stockEntryEventListLaboratoryResearchItem) {
            // validation for constraint: itemType
            if (!$stockEntryEventListLaboratoryResearchItem instanceof \StructType\LaboratoryResearchEvent) {
                throw new \InvalidArgumentException(sprintf('The laboratoryResearch property can only contain items of \StructType\LaboratoryResearchEvent, "%s" given', is_object($stockEntryEventListLaboratoryResearchItem) ? get_class($stockEntryEventListLaboratoryResearchItem) : gettype($stockEntryEventListLaboratoryResearchItem)), __LINE__);
            }
        }
        $this->laboratoryResearch = $laboratoryResearch;
        return $this;
    }
    /**
     * Add item to laboratoryResearch value
     * @throws \InvalidArgumentException
     * @param \StructType\LaboratoryResearchEvent $item
     * @return \StructType\StockEntryEventList
     */
    public function addToLaboratoryResearch(\StructType\LaboratoryResearchEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LaboratoryResearchEvent) {
            throw new \InvalidArgumentException(sprintf('The laboratoryResearch property can only contain items of \StructType\LaboratoryResearchEvent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->laboratoryResearch[] = $item;
        return $this;
    }
    /**
     * Get quarantine value
     * @return \StructType\QuarantineEvent[]|null
     */
    public function getQuarantine()
    {
        return $this->quarantine;
    }
    /**
     * Set quarantine value
     * @throws \InvalidArgumentException
     * @param \StructType\QuarantineEvent[] $quarantine
     * @return \StructType\StockEntryEventList
     */
    public function setQuarantine(array $quarantine = array())
    {
        foreach ($quarantine as $stockEntryEventListQuarantineItem) {
            // validation for constraint: itemType
            if (!$stockEntryEventListQuarantineItem instanceof \StructType\QuarantineEvent) {
                throw new \InvalidArgumentException(sprintf('The quarantine property can only contain items of \StructType\QuarantineEvent, "%s" given', is_object($stockEntryEventListQuarantineItem) ? get_class($stockEntryEventListQuarantineItem) : gettype($stockEntryEventListQuarantineItem)), __LINE__);
            }
        }
        $this->quarantine = $quarantine;
        return $this;
    }
    /**
     * Add item to quarantine value
     * @throws \InvalidArgumentException
     * @param \StructType\QuarantineEvent $item
     * @return \StructType\StockEntryEventList
     */
    public function addToQuarantine(\StructType\QuarantineEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\QuarantineEvent) {
            throw new \InvalidArgumentException(sprintf('The quarantine property can only contain items of \StructType\QuarantineEvent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->quarantine[] = $item;
        return $this;
    }
    /**
     * Get immunization value
     * @return \StructType\AnimalMedicationEvent[]|null
     */
    public function getImmunization()
    {
        return $this->immunization;
    }
    /**
     * Set immunization value
     * @throws \InvalidArgumentException
     * @param \StructType\AnimalMedicationEvent[] $immunization
     * @return \StructType\StockEntryEventList
     */
    public function setImmunization(array $immunization = array())
    {
        foreach ($immunization as $stockEntryEventListImmunizationItem) {
            // validation for constraint: itemType
            if (!$stockEntryEventListImmunizationItem instanceof \StructType\AnimalMedicationEvent) {
                throw new \InvalidArgumentException(sprintf('The immunization property can only contain items of \StructType\AnimalMedicationEvent, "%s" given', is_object($stockEntryEventListImmunizationItem) ? get_class($stockEntryEventListImmunizationItem) : gettype($stockEntryEventListImmunizationItem)), __LINE__);
            }
        }
        $this->immunization = $immunization;
        return $this;
    }
    /**
     * Add item to immunization value
     * @throws \InvalidArgumentException
     * @param \StructType\AnimalMedicationEvent $item
     * @return \StructType\StockEntryEventList
     */
    public function addToImmunization(\StructType\AnimalMedicationEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AnimalMedicationEvent) {
            throw new \InvalidArgumentException(sprintf('The immunization property can only contain items of \StructType\AnimalMedicationEvent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->immunization[] = $item;
        return $this;
    }
    /**
     * Get veterinaryEvent value
     * @return \StructType\VeterinaryEvent[]|null
     */
    public function getVeterinaryEvent()
    {
        return $this->veterinaryEvent;
    }
    /**
     * Set veterinaryEvent value
     * @throws \InvalidArgumentException
     * @param \StructType\VeterinaryEvent[] $veterinaryEvent
     * @return \StructType\StockEntryEventList
     */
    public function setVeterinaryEvent(array $veterinaryEvent = array())
    {
        foreach ($veterinaryEvent as $stockEntryEventListVeterinaryEventItem) {
            // validation for constraint: itemType
            if (!$stockEntryEventListVeterinaryEventItem instanceof \StructType\VeterinaryEvent) {
                throw new \InvalidArgumentException(sprintf('The veterinaryEvent property can only contain items of \StructType\VeterinaryEvent, "%s" given', is_object($stockEntryEventListVeterinaryEventItem) ? get_class($stockEntryEventListVeterinaryEventItem) : gettype($stockEntryEventListVeterinaryEventItem)), __LINE__);
            }
        }
        $this->veterinaryEvent = $veterinaryEvent;
        return $this;
    }
    /**
     * Add item to veterinaryEvent value
     * @throws \InvalidArgumentException
     * @param \StructType\VeterinaryEvent $item
     * @return \StructType\StockEntryEventList
     */
    public function addToVeterinaryEvent(\StructType\VeterinaryEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VeterinaryEvent) {
            throw new \InvalidArgumentException(sprintf('The veterinaryEvent property can only contain items of \StructType\VeterinaryEvent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->veterinaryEvent[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockEntryEventList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
