<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentRoute StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список пунктов перегрузки груза.
 * @subpackage Structs
 */
class ShipmentRoute extends AbstractStructBase
{
    /**
     * The routePoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ShipmentRoutePoint[]
     */
    public $routePoint;
    /**
     * Constructor method for ShipmentRoute
     * @uses ShipmentRoute::setRoutePoint()
     * @param \StructType\ShipmentRoutePoint[] $routePoint
     */
    public function __construct(array $routePoint = array())
    {
        $this
            ->setRoutePoint($routePoint);
    }
    /**
     * Get routePoint value
     * @return \StructType\ShipmentRoutePoint[]|null
     */
    public function getRoutePoint()
    {
        return $this->routePoint;
    }
    /**
     * Set routePoint value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentRoutePoint[] $routePoint
     * @return \StructType\ShipmentRoute
     */
    public function setRoutePoint(array $routePoint = array())
    {
        foreach ($routePoint as $shipmentRouteRoutePointItem) {
            // validation for constraint: itemType
            if (!$shipmentRouteRoutePointItem instanceof \StructType\ShipmentRoutePoint) {
                throw new \InvalidArgumentException(sprintf('The routePoint property can only contain items of \StructType\ShipmentRoutePoint, "%s" given', is_object($shipmentRouteRoutePointItem) ? get_class($shipmentRouteRoutePointItem) : gettype($shipmentRouteRoutePointItem)), __LINE__);
            }
        }
        $this->routePoint = $routePoint;
        return $this;
    }
    /**
     * Add item to routePoint value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentRoutePoint $item
     * @return \StructType\ShipmentRoute
     */
    public function addToRoutePoint(\StructType\ShipmentRoutePoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShipmentRoutePoint) {
            throw new \InvalidArgumentException(sprintf('The routePoint property can only contain items of \StructType\ShipmentRoutePoint, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->routePoint[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShipmentRoute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
