<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RouteSectionR13nRules StructType
 * Meta informations extracted from the WSDL
 * - documentation: Правила перемещения партии согласно регионализации между двух точек маршрута.
 * @subpackage Structs
 */
class RouteSectionR13nRules extends AbstractStructBase
{
    /**
     * The sqnId
     * Meta informations extracted from the WSDL
     * - documentation: Порядовый номер отрезка маршрута. | Тип, описывающий порядковый номер.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $sqnId;
    /**
     * The appliedR13nRule
     * Meta informations extracted from the WSDL
     * - documentation: Применяемое правило перемещения для каждой категории груза на данном участке маршрута.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RegionalizationShippingRule[]
     */
    public $appliedR13nRule;
    /**
     * Constructor method for RouteSectionR13nRules
     * @uses RouteSectionR13nRules::setSqnId()
     * @uses RouteSectionR13nRules::setAppliedR13nRule()
     * @param int $sqnId
     * @param \StructType\RegionalizationShippingRule[] $appliedR13nRule
     */
    public function __construct($sqnId = null, array $appliedR13nRule = array())
    {
        $this
            ->setSqnId($sqnId)
            ->setAppliedR13nRule($appliedR13nRule);
    }
    /**
     * Get sqnId value
     * @return int|null
     */
    public function getSqnId()
    {
        return $this->sqnId;
    }
    /**
     * Set sqnId value
     * @param int $sqnId
     * @return \StructType\RouteSectionR13nRules
     */
    public function setSqnId($sqnId = null)
    {
        // validation for constraint: int
        if (!is_null($sqnId) && !is_numeric($sqnId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sqnId)), __LINE__);
        }
        $this->sqnId = $sqnId;
        return $this;
    }
    /**
     * Get appliedR13nRule value
     * @return \StructType\RegionalizationShippingRule[]|null
     */
    public function getAppliedR13nRule()
    {
        return $this->appliedR13nRule;
    }
    /**
     * Set appliedR13nRule value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionalizationShippingRule[] $appliedR13nRule
     * @return \StructType\RouteSectionR13nRules
     */
    public function setAppliedR13nRule(array $appliedR13nRule = array())
    {
        foreach ($appliedR13nRule as $routeSectionR13nRulesAppliedR13nRuleItem) {
            // validation for constraint: itemType
            if (!$routeSectionR13nRulesAppliedR13nRuleItem instanceof \StructType\RegionalizationShippingRule) {
                throw new \InvalidArgumentException(sprintf('The appliedR13nRule property can only contain items of \StructType\RegionalizationShippingRule, "%s" given', is_object($routeSectionR13nRulesAppliedR13nRuleItem) ? get_class($routeSectionR13nRulesAppliedR13nRuleItem) : gettype($routeSectionR13nRulesAppliedR13nRuleItem)), __LINE__);
            }
        }
        $this->appliedR13nRule = $appliedR13nRule;
        return $this;
    }
    /**
     * Add item to appliedR13nRule value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionalizationShippingRule $item
     * @return \StructType\RouteSectionR13nRules
     */
    public function addToAppliedR13nRule(\StructType\RegionalizationShippingRule $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RegionalizationShippingRule) {
            throw new \InvalidArgumentException(sprintf('The appliedR13nRule property can only contain items of \StructType\RegionalizationShippingRule, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->appliedR13nRule[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RouteSectionR13nRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
