<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResolveDiscrepancyRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявка на регистрацию несоответствий в записях складского журнала, выявленных в результате инвентаризации.
 * @subpackage Structs
 */
class ResolveDiscrepancyRequest extends MercuryApplicationRequest
{
    /**
     * The enterprise
     * Meta informations extracted from the WSDL
     * - documentation: Предприятие.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Enterprise
     */
    public $enterprise;
    /**
     * The inventoryDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата инвентаризации/обнаружения несоответствия.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $inventoryDate;
    /**
     * The responsible
     * Meta informations extracted from the WSDL
     * - documentation: Ответственный за инвентаризацию.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\User
     */
    public $responsible;
    /**
     * The stockDiscrepancy
     * Meta informations extracted from the WSDL
     * - documentation: Несоответствие в записях складского журнала.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\StockDiscrepancy[]
     */
    public $stockDiscrepancy;
    /**
     * The discrepancyReport
     * Meta informations extracted from the WSDL
     * - documentation: Акт о несоответствии.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\DiscrepancyReport[]
     */
    public $discrepancyReport;
    /**
     * Constructor method for ResolveDiscrepancyRequest
     * @uses ResolveDiscrepancyRequest::setEnterprise()
     * @uses ResolveDiscrepancyRequest::setInventoryDate()
     * @uses ResolveDiscrepancyRequest::setResponsible()
     * @uses ResolveDiscrepancyRequest::setStockDiscrepancy()
     * @uses ResolveDiscrepancyRequest::setDiscrepancyReport()
     * @param \StructType\Enterprise $enterprise
     * @param string $inventoryDate
     * @param \StructType\User $responsible
     * @param \StructType\StockDiscrepancy[] $stockDiscrepancy
     * @param \StructType\DiscrepancyReport[] $discrepancyReport
     */
    public function __construct(\StructType\Enterprise $enterprise = null, $inventoryDate = null, \StructType\User $responsible = null, array $stockDiscrepancy = array(), array $discrepancyReport = array())
    {
        $this
            ->setEnterprise($enterprise)
            ->setInventoryDate($inventoryDate)
            ->setResponsible($responsible)
            ->setStockDiscrepancy($stockDiscrepancy)
            ->setDiscrepancyReport($discrepancyReport);
    }
    /**
     * Get enterprise value
     * @return \StructType\Enterprise
     */
    public function getEnterprise()
    {
        return $this->enterprise;
    }
    /**
     * Set enterprise value
     * @param \StructType\Enterprise $enterprise
     * @return \StructType\ResolveDiscrepancyRequest
     */
    public function setEnterprise(\StructType\Enterprise $enterprise = null)
    {
        $this->enterprise = $enterprise;
        return $this;
    }
    /**
     * Get inventoryDate value
     * @return string
     */
    public function getInventoryDate()
    {
        return $this->inventoryDate;
    }
    /**
     * Set inventoryDate value
     * @param string $inventoryDate
     * @return \StructType\ResolveDiscrepancyRequest
     */
    public function setInventoryDate($inventoryDate = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryDate) && !is_string($inventoryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inventoryDate)), __LINE__);
        }
        $this->inventoryDate = $inventoryDate;
        return $this;
    }
    /**
     * Get responsible value
     * @return \StructType\User
     */
    public function getResponsible()
    {
        return $this->responsible;
    }
    /**
     * Set responsible value
     * @param \StructType\User $responsible
     * @return \StructType\ResolveDiscrepancyRequest
     */
    public function setResponsible(\StructType\User $responsible = null)
    {
        $this->responsible = $responsible;
        return $this;
    }
    /**
     * Get stockDiscrepancy value
     * @return \StructType\StockDiscrepancy[]
     */
    public function getStockDiscrepancy()
    {
        return $this->stockDiscrepancy;
    }
    /**
     * Set stockDiscrepancy value
     * @throws \InvalidArgumentException
     * @param \StructType\StockDiscrepancy[] $stockDiscrepancy
     * @return \StructType\ResolveDiscrepancyRequest
     */
    public function setStockDiscrepancy(array $stockDiscrepancy = array())
    {
        foreach ($stockDiscrepancy as $resolveDiscrepancyRequestStockDiscrepancyItem) {
            // validation for constraint: itemType
            if (!$resolveDiscrepancyRequestStockDiscrepancyItem instanceof \StructType\StockDiscrepancy) {
                throw new \InvalidArgumentException(sprintf('The stockDiscrepancy property can only contain items of \StructType\StockDiscrepancy, "%s" given', is_object($resolveDiscrepancyRequestStockDiscrepancyItem) ? get_class($resolveDiscrepancyRequestStockDiscrepancyItem) : gettype($resolveDiscrepancyRequestStockDiscrepancyItem)), __LINE__);
            }
        }
        $this->stockDiscrepancy = $stockDiscrepancy;
        return $this;
    }
    /**
     * Add item to stockDiscrepancy value
     * @throws \InvalidArgumentException
     * @param \StructType\StockDiscrepancy $item
     * @return \StructType\ResolveDiscrepancyRequest
     */
    public function addToStockDiscrepancy(\StructType\StockDiscrepancy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockDiscrepancy) {
            throw new \InvalidArgumentException(sprintf('The stockDiscrepancy property can only contain items of \StructType\StockDiscrepancy, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockDiscrepancy[] = $item;
        return $this;
    }
    /**
     * Get discrepancyReport value
     * @return \StructType\DiscrepancyReport[]
     */
    public function getDiscrepancyReport()
    {
        return $this->discrepancyReport;
    }
    /**
     * Set discrepancyReport value
     * @throws \InvalidArgumentException
     * @param \StructType\DiscrepancyReport[] $discrepancyReport
     * @return \StructType\ResolveDiscrepancyRequest
     */
    public function setDiscrepancyReport(array $discrepancyReport = array())
    {
        foreach ($discrepancyReport as $resolveDiscrepancyRequestDiscrepancyReportItem) {
            // validation for constraint: itemType
            if (!$resolveDiscrepancyRequestDiscrepancyReportItem instanceof \StructType\DiscrepancyReport) {
                throw new \InvalidArgumentException(sprintf('The discrepancyReport property can only contain items of \StructType\DiscrepancyReport, "%s" given', is_object($resolveDiscrepancyRequestDiscrepancyReportItem) ? get_class($resolveDiscrepancyRequestDiscrepancyReportItem) : gettype($resolveDiscrepancyRequestDiscrepancyReportItem)), __LINE__);
            }
        }
        $this->discrepancyReport = $discrepancyReport;
        return $this;
    }
    /**
     * Add item to discrepancyReport value
     * @throws \InvalidArgumentException
     * @param \StructType\DiscrepancyReport $item
     * @return \StructType\ResolveDiscrepancyRequest
     */
    public function addToDiscrepancyReport(\StructType\DiscrepancyReport $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DiscrepancyReport) {
            throw new \InvalidArgumentException(sprintf('The discrepancyReport property can only contain items of \StructType\DiscrepancyReport, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->discrepancyReport[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResolveDiscrepancyRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
