<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionalizationRequirement StructType
 * Meta informations extracted from the WSDL
 * - documentation: Требование к перемещению партии в отношении к определенному заболеванию.
 * @subpackage Structs
 */
class RegionalizationRequirement extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: Вид требования: перемещение запрещено, перемещение разрешено или перемещение разрешено при обязательном соблюдении условий.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The relatedDisease
     * Meta informations extracted from the WSDL
     * - documentation: Заболевание, к которому относится данное требование
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AnimalDisease
     */
    public $relatedDisease;
    /**
     * The conditionGroup
     * Meta informations extracted from the WSDL
     * - documentation: Группа условий регионализации, соблюдаемых при перевозке продукции. Имеет смысл, если тип требования `type` имеет значение 3
     * (перемещение разрешено при обязательном соблюдении условий). В этом случае требование считается выполненным, если выполнена одна из
     * альтернативных групп условий `conditionGroup`. См. условие выполнения группы в описании типа `dt:RegionalizationConditionGroup`.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RegionalizationConditionGroup[]
     */
    public $conditionGroup;
    /**
     * Constructor method for RegionalizationRequirement
     * @uses RegionalizationRequirement::setType()
     * @uses RegionalizationRequirement::setRelatedDisease()
     * @uses RegionalizationRequirement::setConditionGroup()
     * @param string $type
     * @param \StructType\AnimalDisease $relatedDisease
     * @param \StructType\RegionalizationConditionGroup[] $conditionGroup
     */
    public function __construct($type = null, \StructType\AnimalDisease $relatedDisease = null, array $conditionGroup = array())
    {
        $this
            ->setType($type)
            ->setRelatedDisease($relatedDisease)
            ->setConditionGroup($conditionGroup);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\RegionalizationDecision::valueIsValid()
     * @uses \EnumType\RegionalizationDecision::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\RegionalizationRequirement
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RegionalizationDecision::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\RegionalizationDecision::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get relatedDisease value
     * @return \StructType\AnimalDisease|null
     */
    public function getRelatedDisease()
    {
        return $this->relatedDisease;
    }
    /**
     * Set relatedDisease value
     * @param \StructType\AnimalDisease $relatedDisease
     * @return \StructType\RegionalizationRequirement
     */
    public function setRelatedDisease(\StructType\AnimalDisease $relatedDisease = null)
    {
        $this->relatedDisease = $relatedDisease;
        return $this;
    }
    /**
     * Get conditionGroup value
     * @return \StructType\RegionalizationConditionGroup[]|null
     */
    public function getConditionGroup()
    {
        return $this->conditionGroup;
    }
    /**
     * Set conditionGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionalizationConditionGroup[] $conditionGroup
     * @return \StructType\RegionalizationRequirement
     */
    public function setConditionGroup(array $conditionGroup = array())
    {
        foreach ($conditionGroup as $regionalizationRequirementConditionGroupItem) {
            // validation for constraint: itemType
            if (!$regionalizationRequirementConditionGroupItem instanceof \StructType\RegionalizationConditionGroup) {
                throw new \InvalidArgumentException(sprintf('The conditionGroup property can only contain items of \StructType\RegionalizationConditionGroup, "%s" given', is_object($regionalizationRequirementConditionGroupItem) ? get_class($regionalizationRequirementConditionGroupItem) : gettype($regionalizationRequirementConditionGroupItem)), __LINE__);
            }
        }
        $this->conditionGroup = $conditionGroup;
        return $this;
    }
    /**
     * Add item to conditionGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionalizationConditionGroup $item
     * @return \StructType\RegionalizationRequirement
     */
    public function addToConditionGroup(\StructType\RegionalizationConditionGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RegionalizationConditionGroup) {
            throw new \InvalidArgumentException(sprintf('The conditionGroup property can only contain items of \StructType\RegionalizationConditionGroup, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->conditionGroup[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegionalizationRequirement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
