<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionalizationRegionStatus StructType
 * Meta informations extracted from the WSDL
 * - documentation: Статус регионализации
 * @subpackage Structs
 */
class RegionalizationRegionStatus extends GenericVersioningEntity
{
    /**
     * The referenceNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер статуса региона в реестре. | Тип, описывающий идентификатор.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $referenceNumber;
    /**
     * The r13nZone
     * Meta informations extracted from the WSDL
     * - documentation: Территория/регион
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Area
     */
    public $r13nZone;
    /**
     * The excludedR13nZone
     * Meta informations extracted from the WSDL
     * - documentation: Территория/регион внутри `r13Zone` с отличным (другим) статусом регионализации.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Area[]
     */
    public $excludedR13nZone;
    /**
     * The r13nStatus
     * Meta informations extracted from the WSDL
     * - documentation: Статус регионализации
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RegionalizationStatus[]
     */
    public $r13nStatus;
    /**
     * Constructor method for RegionalizationRegionStatus
     * @uses RegionalizationRegionStatus::setReferenceNumber()
     * @uses RegionalizationRegionStatus::setR13nZone()
     * @uses RegionalizationRegionStatus::setExcludedR13nZone()
     * @uses RegionalizationRegionStatus::setR13nStatus()
     * @param string $referenceNumber
     * @param \StructType\Area $r13nZone
     * @param \StructType\Area[] $excludedR13nZone
     * @param \StructType\RegionalizationStatus[] $r13nStatus
     */
    public function __construct($referenceNumber = null, \StructType\Area $r13nZone = null, array $excludedR13nZone = array(), array $r13nStatus = array())
    {
        $this
            ->setReferenceNumber($referenceNumber)
            ->setR13nZone($r13nZone)
            ->setExcludedR13nZone($excludedR13nZone)
            ->setR13nStatus($r13nStatus);
    }
    /**
     * Get referenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->referenceNumber;
    }
    /**
     * Set referenceNumber value
     * @param string $referenceNumber
     * @return \StructType\RegionalizationRegionStatus
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($referenceNumber) && strlen($referenceNumber) > 100) || (is_array($referenceNumber) && count($referenceNumber) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($referenceNumber) ? strlen($referenceNumber) : count($referenceNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceNumber)), __LINE__);
        }
        $this->referenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get r13nZone value
     * @return \StructType\Area|null
     */
    public function getR13nZone()
    {
        return $this->r13nZone;
    }
    /**
     * Set r13nZone value
     * @param \StructType\Area $r13nZone
     * @return \StructType\RegionalizationRegionStatus
     */
    public function setR13nZone(\StructType\Area $r13nZone = null)
    {
        $this->r13nZone = $r13nZone;
        return $this;
    }
    /**
     * Get excludedR13nZone value
     * @return \StructType\Area[]|null
     */
    public function getExcludedR13nZone()
    {
        return $this->excludedR13nZone;
    }
    /**
     * Set excludedR13nZone value
     * @throws \InvalidArgumentException
     * @param \StructType\Area[] $excludedR13nZone
     * @return \StructType\RegionalizationRegionStatus
     */
    public function setExcludedR13nZone(array $excludedR13nZone = array())
    {
        foreach ($excludedR13nZone as $regionalizationRegionStatusExcludedR13nZoneItem) {
            // validation for constraint: itemType
            if (!$regionalizationRegionStatusExcludedR13nZoneItem instanceof \StructType\Area) {
                throw new \InvalidArgumentException(sprintf('The excludedR13nZone property can only contain items of \StructType\Area, "%s" given', is_object($regionalizationRegionStatusExcludedR13nZoneItem) ? get_class($regionalizationRegionStatusExcludedR13nZoneItem) : gettype($regionalizationRegionStatusExcludedR13nZoneItem)), __LINE__);
            }
        }
        $this->excludedR13nZone = $excludedR13nZone;
        return $this;
    }
    /**
     * Add item to excludedR13nZone value
     * @throws \InvalidArgumentException
     * @param \StructType\Area $item
     * @return \StructType\RegionalizationRegionStatus
     */
    public function addToExcludedR13nZone(\StructType\Area $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Area) {
            throw new \InvalidArgumentException(sprintf('The excludedR13nZone property can only contain items of \StructType\Area, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->excludedR13nZone[] = $item;
        return $this;
    }
    /**
     * Get r13nStatus value
     * @return \StructType\RegionalizationStatus[]|null
     */
    public function getR13nStatus()
    {
        return $this->r13nStatus;
    }
    /**
     * Set r13nStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionalizationStatus[] $r13nStatus
     * @return \StructType\RegionalizationRegionStatus
     */
    public function setR13nStatus(array $r13nStatus = array())
    {
        foreach ($r13nStatus as $regionalizationRegionStatusR13nStatusItem) {
            // validation for constraint: itemType
            if (!$regionalizationRegionStatusR13nStatusItem instanceof \StructType\RegionalizationStatus) {
                throw new \InvalidArgumentException(sprintf('The r13nStatus property can only contain items of \StructType\RegionalizationStatus, "%s" given', is_object($regionalizationRegionStatusR13nStatusItem) ? get_class($regionalizationRegionStatusR13nStatusItem) : gettype($regionalizationRegionStatusR13nStatusItem)), __LINE__);
            }
        }
        $this->r13nStatus = $r13nStatus;
        return $this;
    }
    /**
     * Add item to r13nStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionalizationStatus $item
     * @return \StructType\RegionalizationRegionStatus
     */
    public function addToR13nStatus(\StructType\RegionalizationStatus $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RegionalizationStatus) {
            throw new \InvalidArgumentException(sprintf('The r13nStatus property can only contain items of \StructType\RegionalizationStatus, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->r13nStatus[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegionalizationRegionStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
