<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionalizationConditionList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список условий перемещения.
 * @subpackage Structs
 */
class RegionalizationConditionList extends EntityList
{
    /**
     * The condition
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RegionalizationCondition[]
     */
    public $condition;
    /**
     * Constructor method for RegionalizationConditionList
     * @uses RegionalizationConditionList::setCondition()
     * @param \StructType\RegionalizationCondition[] $condition
     */
    public function __construct(array $condition = array())
    {
        $this
            ->setCondition($condition);
    }
    /**
     * Get condition value
     * @return \StructType\RegionalizationCondition[]|null
     */
    public function getCondition()
    {
        return $this->condition;
    }
    /**
     * Set condition value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionalizationCondition[] $condition
     * @return \StructType\RegionalizationConditionList
     */
    public function setCondition(array $condition = array())
    {
        foreach ($condition as $regionalizationConditionListConditionItem) {
            // validation for constraint: itemType
            if (!$regionalizationConditionListConditionItem instanceof \StructType\RegionalizationCondition) {
                throw new \InvalidArgumentException(sprintf('The condition property can only contain items of \StructType\RegionalizationCondition, "%s" given', is_object($regionalizationConditionListConditionItem) ? get_class($regionalizationConditionListConditionItem) : gettype($regionalizationConditionListConditionItem)), __LINE__);
            }
        }
        $this->condition = $condition;
        return $this;
    }
    /**
     * Add item to condition value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionalizationCondition $item
     * @return \StructType\RegionalizationConditionList
     */
    public function addToCondition(\StructType\RegionalizationCondition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RegionalizationCondition) {
            throw new \InvalidArgumentException(sprintf('The condition property can only contain items of \StructType\RegionalizationCondition, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->condition[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegionalizationConditionList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
