<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип-обертка для списка регионов.
 * @subpackage Structs
 */
class RegionList extends EntityList
{
    /**
     * The region
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Region[]
     */
    public $region;
    /**
     * Constructor method for RegionList
     * @uses RegionList::setRegion()
     * @param \StructType\Region[] $region
     */
    public function __construct(array $region = array())
    {
        $this
            ->setRegion($region);
    }
    /**
     * Get region value
     * @return \StructType\Region[]|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @throws \InvalidArgumentException
     * @param \StructType\Region[] $region
     * @return \StructType\RegionList
     */
    public function setRegion(array $region = array())
    {
        foreach ($region as $regionListRegionItem) {
            // validation for constraint: itemType
            if (!$regionListRegionItem instanceof \StructType\Region) {
                throw new \InvalidArgumentException(sprintf('The region property can only contain items of \StructType\Region, "%s" given', is_object($regionListRegionItem) ? get_class($regionListRegionItem) : gettype($regionListRegionItem)), __LINE__);
            }
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Add item to region value
     * @throws \InvalidArgumentException
     * @param \StructType\Region $item
     * @return \StructType\RegionList
     */
    public function addToRegion(\StructType\Region $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Region) {
            throw new \InvalidArgumentException(sprintf('The region property can only contain items of \StructType\Region, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->region[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegionList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
