<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for receiveApplicationResultRequest StructType
 * @subpackage Structs
 */
class ReceiveApplicationResultRequest extends AbstractStructBase
{
    /**
     * The apiKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $apiKey;
    /**
     * The issuerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: Тип, описывающий уникальный идентификатор любой сущности системы.
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $issuerId;
    /**
     * The applicationId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: Тип, описывающий уникальный идентификатор любой сущности системы.
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $applicationId;
    /**
     * Constructor method for receiveApplicationResultRequest
     * @uses ReceiveApplicationResultRequest::setApiKey()
     * @uses ReceiveApplicationResultRequest::setIssuerId()
     * @uses ReceiveApplicationResultRequest::setApplicationId()
     * @param string $apiKey
     * @param string $issuerId
     * @param string $applicationId
     */
    public function __construct($apiKey = null, $issuerId = null, $applicationId = null)
    {
        $this
            ->setApiKey($apiKey)
            ->setIssuerId($issuerId)
            ->setApplicationId($applicationId);
    }
    /**
     * Get apiKey value
     * @return string
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \StructType\ReceiveApplicationResultRequest
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apiKey)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
    /**
     * Get issuerId value
     * @return string
     */
    public function getIssuerId()
    {
        return $this->issuerId;
    }
    /**
     * Set issuerId value
     * @param string $issuerId
     * @return \StructType\ReceiveApplicationResultRequest
     */
    public function setIssuerId($issuerId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($issuerId) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $issuerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($issuerId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($issuerId) && !is_string($issuerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuerId)), __LINE__);
        }
        $this->issuerId = $issuerId;
        return $this;
    }
    /**
     * Get applicationId value
     * @return string
     */
    public function getApplicationId()
    {
        return $this->applicationId;
    }
    /**
     * Set applicationId value
     * @param string $applicationId
     * @return \StructType\ReceiveApplicationResultRequest
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($applicationId) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($applicationId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($applicationId) && !is_string($applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationId)), __LINE__);
        }
        $this->applicationId = $applicationId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReceiveApplicationResultRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
