<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuarantineEvent StructType
 * Meta informations extracted from the WSDL
 * - documentation: Карантин животных или продукции
 * @subpackage Structs
 */
class QuarantineEvent extends VeterinaryEvent
{
    /**
     * The duration
     * Meta informations extracted from the WSDL
     * - documentation: Срок действия карантина. Указывается количество дней
     * - minOccurs: 0
     * @var int
     */
    public $duration;
    /**
     * Constructor method for QuarantineEvent
     * @uses QuarantineEvent::setDuration()
     * @param int $duration
     */
    public function __construct($duration = null)
    {
        $this
            ->setDuration($duration);
    }
    /**
     * Get duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param int $duration
     * @return \StructType\QuarantineEvent
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !is_numeric($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($duration)), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QuarantineEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
