<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductMarks StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список маркировок продукции. Под маркировкой понимается всё, что может быть физически нанесено на упаковку
 * или непосредственно на продукцию. Для каждой маркировки может быть указан её тип (см. атрибут class), который также может определять формат
 * маркировки. Список возможных типов см. в перечислении dt:ProductMarkingClass. | Строковый тип с ограничением максимальной длины.
 * - maxLength: 255
 * @subpackage Structs
 */
class ProductMarks extends AbstractStructBase
{
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - documentation: Строковый тип с ограничением максимальной длины.
     * - maxLength: 255
     * @var string
     */
    public $_;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - default: UNDEFINED
     * - use: optional
     * @var string
     */
    public $class;
    /**
     * Constructor method for ProductMarks
     * @uses ProductMarks::set_()
     * @uses ProductMarks::setClass()
     * @param string $_
     * @param string $class
     */
    public function __construct($_ = null, $class = 'UNDEFINED')
    {
        $this
            ->set_($_)
            ->setClass($class);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\ProductMarks
     */
    public function set_($_ = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($_) && strlen($_) > 255) || (is_array($_) && count($_) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($_) ? strlen($_) : count($_)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \EnumType\ProductMarkingClass::valueIsValid()
     * @uses \EnumType\ProductMarkingClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \StructType\ProductMarks
     */
    public function setClass($class = 'UNDEFINED')
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductMarkingClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', \EnumType\ProductMarkingClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductMarks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
