<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductItemList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список наименование продукции.
 * @subpackage Structs
 */
class ProductItemList extends EntityList
{
    /**
     * The productItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProductItem[]
     */
    public $productItem;
    /**
     * Constructor method for ProductItemList
     * @uses ProductItemList::setProductItem()
     * @param \StructType\ProductItem[] $productItem
     */
    public function __construct(array $productItem = array())
    {
        $this
            ->setProductItem($productItem);
    }
    /**
     * Get productItem value
     * @return \StructType\ProductItem[]|null
     */
    public function getProductItem()
    {
        return $this->productItem;
    }
    /**
     * Set productItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductItem[] $productItem
     * @return \StructType\ProductItemList
     */
    public function setProductItem(array $productItem = array())
    {
        foreach ($productItem as $productItemListProductItemItem) {
            // validation for constraint: itemType
            if (!$productItemListProductItemItem instanceof \StructType\ProductItem) {
                throw new \InvalidArgumentException(sprintf('The productItem property can only contain items of \StructType\ProductItem, "%s" given', is_object($productItemListProductItemItem) ? get_class($productItemListProductItemItem) : gettype($productItemListProductItemItem)), __LINE__);
            }
        }
        $this->productItem = $productItem;
        return $this;
    }
    /**
     * Add item to productItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductItem $item
     * @return \StructType\ProductItemList
     */
    public function addToProductItem(\StructType\ProductItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductItem) {
            throw new \InvalidArgumentException(sprintf('The productItem property can only contain items of \StructType\ProductItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->productItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductItemList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
