<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessIncomingDeliveryRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявка на оформление входящей поставки. Предназначена для пакетного гашения электронных ВСД в случае полной приёмки или
 * полного возврата, не предусматривающих создание акта расхождений. Максимальное допустимое количество входящих ВСД (партий) в запросе --
 * 50 (уточнить значение).
 * @subpackage Structs
 */
class ProcessIncomingDeliveryRequest extends MercuryApplicationRequest
{
    /**
     * The delivery
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о поставке. Поставка соответствует множеству партий, следующих в одном транспортном средстве в адрес одного
     * получателя. Для объекта delivery не заполняется элемент consignment -- считаем, что сведения о партии совпадают с данными входящего ВСД. Остальные
     * элементы объекта delivery заполняются в соответствии с атрибутами поставки: consignor - отправитель consignee - получатель broker - посредник/перевозчик
     * transportInfo - сведения о транспорте transportStorageType - режим хранения при перевозке shipmentRoute - маршрут следования В разделе accompanyingForms заполняются
     * элементы waybill и vetCertificate, элемент vetCertificate указывается для каждого ВСД из поставки. Идентификатор входящего электронного ВСД передаётся в
     * поле vetCertificate/uuid. Все перечисленные в блоке accompanyingForms/vetCertificate ВСД должны соответствовать сведениям о поставке, указанным в блоке delivery:
     * consignor - отправитель consignee - получатель broker - посредник/перевозчик transportInfo - сведения о транспорте transportStorageType - режим хранения при перевозке
     * В случае несоответствия как минимум для одного ВСД заявка отклоняется полностью с соответствующей ошибкой.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Delivery
     */
    public $delivery;
    /**
     * The deliveryFacts
     * Meta informations extracted from the WSDL
     * - documentation: Результаты приёмки. Допускаются следующие значения дочерних элементов: vetCertificatePresence = ELECTRONIC decision = ACCEPT_ALL, RETURN_ALL docInspection/result =
     * CORRESPONDS vetInspection/result = CORRESPONDS Если значения для этих полей в запросе отличаются от допустимых, заявка отклоняется.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DeliveryFactList
     */
    public $deliveryFacts;
    /**
     * The returnedDelivery
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о возврате продукции. В случае возврата (RETURN_ALL) правила заполнения блока returnedDelivery те же, что и для операции
     * ProcessIncomingConsignmentRequest. Блок consignment не заполняется -- считаем, что сведения о партии совпадают с данными входящего ВСД.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Delivery
     */
    public $returnedDelivery;
    /**
     * Constructor method for ProcessIncomingDeliveryRequest
     * @uses ProcessIncomingDeliveryRequest::setDelivery()
     * @uses ProcessIncomingDeliveryRequest::setDeliveryFacts()
     * @uses ProcessIncomingDeliveryRequest::setReturnedDelivery()
     * @param \StructType\Delivery $delivery
     * @param \StructType\DeliveryFactList $deliveryFacts
     * @param \StructType\Delivery $returnedDelivery
     */
    public function __construct(\StructType\Delivery $delivery = null, \StructType\DeliveryFactList $deliveryFacts = null, \StructType\Delivery $returnedDelivery = null)
    {
        $this
            ->setDelivery($delivery)
            ->setDeliveryFacts($deliveryFacts)
            ->setReturnedDelivery($returnedDelivery);
    }
    /**
     * Get delivery value
     * @return \StructType\Delivery
     */
    public function getDelivery()
    {
        return $this->delivery;
    }
    /**
     * Set delivery value
     * @param \StructType\Delivery $delivery
     * @return \StructType\ProcessIncomingDeliveryRequest
     */
    public function setDelivery(\StructType\Delivery $delivery = null)
    {
        $this->delivery = $delivery;
        return $this;
    }
    /**
     * Get deliveryFacts value
     * @return \StructType\DeliveryFactList
     */
    public function getDeliveryFacts()
    {
        return $this->deliveryFacts;
    }
    /**
     * Set deliveryFacts value
     * @param \StructType\DeliveryFactList $deliveryFacts
     * @return \StructType\ProcessIncomingDeliveryRequest
     */
    public function setDeliveryFacts(\StructType\DeliveryFactList $deliveryFacts = null)
    {
        $this->deliveryFacts = $deliveryFacts;
        return $this;
    }
    /**
     * Get returnedDelivery value
     * @return \StructType\Delivery|null
     */
    public function getReturnedDelivery()
    {
        return $this->returnedDelivery;
    }
    /**
     * Set returnedDelivery value
     * @param \StructType\Delivery $returnedDelivery
     * @return \StructType\ProcessIncomingDeliveryRequest
     */
    public function setReturnedDelivery(\StructType\Delivery $returnedDelivery = null)
    {
        $this->returnedDelivery = $returnedDelivery;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcessIncomingDeliveryRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
