<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackingType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Вид упаковки
 * @subpackage Structs
 */
class PackingType extends GenericVersioningEntity
{
    /**
     * The globalID
     * Meta informations extracted from the WSDL
     * - documentation: Уникальный идентификатор упаковки.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $globalID;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование упаковки. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * Constructor method for PackingType
     * @uses PackingType::setGlobalID()
     * @uses PackingType::setName()
     * @param string $globalID
     * @param string $name
     */
    public function __construct($globalID = null, $name = null)
    {
        $this
            ->setGlobalID($globalID)
            ->setName($name);
    }
    /**
     * Get globalID value
     * @return string|null
     */
    public function getGlobalID()
    {
        return $this->globalID;
    }
    /**
     * Set globalID value
     * @uses \EnumType\PackingCodeType::valueIsValid()
     * @uses \EnumType\PackingCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $globalID
     * @return \StructType\PackingType
     */
    public function setGlobalID($globalID = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PackingCodeType::valueIsValid($globalID)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $globalID, implode(', ', \EnumType\PackingCodeType::getValidValues())), __LINE__);
        }
        $this->globalID = $globalID;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\PackingType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PackingType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
