<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MercuryApplicationRequest StructType
 * @subpackage Structs
 */
class MercuryApplicationRequest extends ApplicationData
{
    /**
     * The localTransactionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: Тип, описывающий идентификатор.
     * - maxLength: 100
     * @var string
     */
    public $localTransactionId;
    /**
     * The initiator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\User
     */
    public $initiator;
    /**
     * The sessionToken
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Одноразовый токен
     * @var string
     */
    public $sessionToken;
    /**
     * Constructor method for MercuryApplicationRequest
     * @uses MercuryApplicationRequest::setLocalTransactionId()
     * @uses MercuryApplicationRequest::setInitiator()
     * @uses MercuryApplicationRequest::setSessionToken()
     * @param string $localTransactionId
     * @param \StructType\User $initiator
     * @param string $sessionToken
     */
    public function __construct($localTransactionId = null, \StructType\User $initiator = null, $sessionToken = null)
    {
        $this
            ->setLocalTransactionId($localTransactionId)
            ->setInitiator($initiator)
            ->setSessionToken($sessionToken);
    }
    /**
     * Get localTransactionId value
     * @return string
     */
    public function getLocalTransactionId()
    {
        return $this->localTransactionId;
    }
    /**
     * Set localTransactionId value
     * @param string $localTransactionId
     * @return \StructType\MercuryApplicationRequest
     */
    public function setLocalTransactionId($localTransactionId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($localTransactionId) && strlen($localTransactionId) > 100) || (is_array($localTransactionId) && count($localTransactionId) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($localTransactionId) ? strlen($localTransactionId) : count($localTransactionId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($localTransactionId) && !is_string($localTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localTransactionId)), __LINE__);
        }
        $this->localTransactionId = $localTransactionId;
        return $this;
    }
    /**
     * Get initiator value
     * @return \StructType\User
     */
    public function getInitiator()
    {
        return $this->initiator;
    }
    /**
     * Set initiator value
     * @param \StructType\User $initiator
     * @return \StructType\MercuryApplicationRequest
     */
    public function setInitiator(\StructType\User $initiator = null)
    {
        $this->initiator = $initiator;
        return $this;
    }
    /**
     * Get sessionToken value
     * @return string|null
     */
    public function getSessionToken()
    {
        return $this->sessionToken;
    }
    /**
     * Set sessionToken value
     * @param string $sessionToken
     * @return \StructType\MercuryApplicationRequest
     */
    public function setSessionToken($sessionToken = null)
    {
        // validation for constraint: string
        if (!is_null($sessionToken) && !is_string($sessionToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionToken)), __LINE__);
        }
        $this->sessionToken = $sessionToken;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MercuryApplicationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
