<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MedicinalDrug StructType
 * Meta informations extracted from the WSDL
 * - documentation: Препарат/вакцина
 * @subpackage Structs
 */
class MedicinalDrug extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Идентификационный (уникальный) номер препарата | Тип, описывающий идентификатор.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $ID;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование препарата | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The series
     * Meta informations extracted from the WSDL
     * - documentation: Номер серии препарата/вакцины | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $series;
    /**
     * The producer
     * Meta informations extracted from the WSDL
     * - documentation: Производитель препарата
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BusinessMember
     */
    public $producer;
    /**
     * Constructor method for MedicinalDrug
     * @uses MedicinalDrug::setID()
     * @uses MedicinalDrug::setName()
     * @uses MedicinalDrug::setSeries()
     * @uses MedicinalDrug::setProducer()
     * @param string $iD
     * @param string $name
     * @param string $series
     * @param \StructType\BusinessMember $producer
     */
    public function __construct($iD = null, $name = null, $series = null, \StructType\BusinessMember $producer = null)
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setSeries($series)
            ->setProducer($producer);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\MedicinalDrug
     */
    public function setID($iD = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iD) && strlen($iD) > 100) || (is_array($iD) && count($iD) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($iD) ? strlen($iD) : count($iD)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\MedicinalDrug
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get series value
     * @return string|null
     */
    public function getSeries()
    {
        return $this->series;
    }
    /**
     * Set series value
     * @param string $series
     * @return \StructType\MedicinalDrug
     */
    public function setSeries($series = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($series) && strlen($series) > 255) || (is_array($series) && count($series) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($series) ? strlen($series) : count($series)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($series) && !is_string($series)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($series)), __LINE__);
        }
        $this->series = $series;
        return $this;
    }
    /**
     * Get producer value
     * @return \StructType\BusinessMember|null
     */
    public function getProducer()
    {
        return $this->producer;
    }
    /**
     * Set producer value
     * @param \StructType\BusinessMember $producer
     * @return \StructType\MedicinalDrug
     */
    public function setProducer(\StructType\BusinessMember $producer = null)
    {
        $this->producer = $producer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MedicinalDrug
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
