<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListOptions StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, определяющий параметры запрашиваемого у сервиса списка объектов.
 * @subpackage Structs
 */
class ListOptions extends AbstractStructBase
{
    /**
     * The count
     * Meta informations extracted from the WSDL
     * - documentation: Максимальное запрашиваемое количество объектов в списке.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $count;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - documentation: Номер элемента, по которому осуществляется смещение первого элемента списка.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $offset;
    /**
     * Constructor method for ListOptions
     * @uses ListOptions::setCount()
     * @uses ListOptions::setOffset()
     * @param int $count
     * @param int $offset
     */
    public function __construct($count = null, $offset = null)
    {
        $this
            ->setCount($count)
            ->setOffset($offset);
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\ListOptions
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\ListOptions
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ListOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
