<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LaboratoryResearchEvent StructType
 * Meta informations extracted from the WSDL
 * - documentation: Лабораторное исследование. Исследование выполняется на конкретный показатель/заболевание в лаборатории.
 * @subpackage Structs
 */
class LaboratoryResearchEvent extends VeterinaryEvent
{
    /**
     * The batchID
     * Meta informations extracted from the WSDL
     * - documentation: Уникальный идентификатор производственной партии продукции, для которой проводились лабораторные исследования. | Тип,
     * описывающий идентификатор.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 100
     * @var string[]
     */
    public $batchID;
    /**
     * The expertiseID
     * Meta informations extracted from the WSDL
     * - documentation: Номер экспертизы | Строковый тип с ограничением максимальной длины.
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $expertiseID;
    /**
     * The indicator
     * Meta informations extracted from the WSDL
     * - documentation: Показатель безопасности
     * - minOccurs: 0
     * @var \StructType\Indicator
     */
    public $indicator;
    /**
     * The disease
     * Meta informations extracted from the WSDL
     * - documentation: Заболевание
     * - minOccurs: 0
     * @var \StructType\AnimalDisease
     */
    public $disease;
    /**
     * The method
     * Meta informations extracted from the WSDL
     * - documentation: Метод исследования
     * - minOccurs: 0
     * @var \StructType\ResearchMethod
     */
    public $method;
    /**
     * The result
     * Meta informations extracted from the WSDL
     * - documentation: Результат исследования
     * - minOccurs: 0
     * @var string
     */
    public $result;
    /**
     * The conclusion
     * Meta informations extracted from the WSDL
     * - documentation: Заключение | Строковый тип без ограничения максимальной длины.
     * - minOccurs: 0
     * @var string
     */
    public $conclusion;
    /**
     * Constructor method for LaboratoryResearchEvent
     * @uses LaboratoryResearchEvent::setBatchID()
     * @uses LaboratoryResearchEvent::setExpertiseID()
     * @uses LaboratoryResearchEvent::setIndicator()
     * @uses LaboratoryResearchEvent::setDisease()
     * @uses LaboratoryResearchEvent::setMethod()
     * @uses LaboratoryResearchEvent::setResult()
     * @uses LaboratoryResearchEvent::setConclusion()
     * @param string[] $batchID
     * @param string $expertiseID
     * @param \StructType\Indicator $indicator
     * @param \StructType\AnimalDisease $disease
     * @param \StructType\ResearchMethod $method
     * @param string $result
     * @param string $conclusion
     */
    public function __construct(array $batchID = array(), $expertiseID = null, \StructType\Indicator $indicator = null, \StructType\AnimalDisease $disease = null, \StructType\ResearchMethod $method = null, $result = null, $conclusion = null)
    {
        $this
            ->setBatchID($batchID)
            ->setExpertiseID($expertiseID)
            ->setIndicator($indicator)
            ->setDisease($disease)
            ->setMethod($method)
            ->setResult($result)
            ->setConclusion($conclusion);
    }
    /**
     * Get batchID value
     * @return string[]|null
     */
    public function getBatchID()
    {
        return $this->batchID;
    }
    /**
     * Set batchID value
     * @throws \InvalidArgumentException
     * @param string[] $batchID
     * @return \StructType\LaboratoryResearchEvent
     */
    public function setBatchID(array $batchID = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($batchID) && strlen($batchID) > 100) || (is_array($batchID) && count($batchID) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($batchID) ? strlen($batchID) : count($batchID)), __LINE__);
        }
        foreach ($batchID as $laboratoryResearchEventBatchIDItem) {
            // validation for constraint: itemType
            if (!is_string($laboratoryResearchEventBatchIDItem)) {
                throw new \InvalidArgumentException(sprintf('The batchID property can only contain items of token, "%s" given', is_object($laboratoryResearchEventBatchIDItem) ? get_class($laboratoryResearchEventBatchIDItem) : gettype($laboratoryResearchEventBatchIDItem)), __LINE__);
            }
        }
        $this->batchID = $batchID;
        return $this;
    }
    /**
     * Add item to batchID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\LaboratoryResearchEvent
     */
    public function addToBatchID($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 100) || (is_array($item) && count($item) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The batchID property can only contain items of token, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->batchID[] = $item;
        return $this;
    }
    /**
     * Get expertiseID value
     * @return string|null
     */
    public function getExpertiseID()
    {
        return $this->expertiseID;
    }
    /**
     * Set expertiseID value
     * @param string $expertiseID
     * @return \StructType\LaboratoryResearchEvent
     */
    public function setExpertiseID($expertiseID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($expertiseID) && strlen($expertiseID) > 255) || (is_array($expertiseID) && count($expertiseID) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($expertiseID) ? strlen($expertiseID) : count($expertiseID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($expertiseID) && !is_string($expertiseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expertiseID)), __LINE__);
        }
        $this->expertiseID = $expertiseID;
        return $this;
    }
    /**
     * Get indicator value
     * @return \StructType\Indicator|null
     */
    public function getIndicator()
    {
        return $this->indicator;
    }
    /**
     * Set indicator value
     * @param \StructType\Indicator $indicator
     * @return \StructType\LaboratoryResearchEvent
     */
    public function setIndicator(\StructType\Indicator $indicator = null)
    {
        $this->indicator = $indicator;
        return $this;
    }
    /**
     * Get disease value
     * @return \StructType\AnimalDisease|null
     */
    public function getDisease()
    {
        return $this->disease;
    }
    /**
     * Set disease value
     * @param \StructType\AnimalDisease $disease
     * @return \StructType\LaboratoryResearchEvent
     */
    public function setDisease(\StructType\AnimalDisease $disease = null)
    {
        $this->disease = $disease;
        return $this;
    }
    /**
     * Get method value
     * @return \StructType\ResearchMethod|null
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * Set method value
     * @param \StructType\ResearchMethod $method
     * @return \StructType\LaboratoryResearchEvent
     */
    public function setMethod(\StructType\ResearchMethod $method = null)
    {
        $this->method = $method;
        return $this;
    }
    /**
     * Get result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @uses \EnumType\ResearchResult::valueIsValid()
     * @uses \EnumType\ResearchResult::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $result
     * @return \StructType\LaboratoryResearchEvent
     */
    public function setResult($result = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ResearchResult::valueIsValid($result)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $result, implode(', ', \EnumType\ResearchResult::getValidValues())), __LINE__);
        }
        $this->result = $result;
        return $this;
    }
    /**
     * Get conclusion value
     * @return string|null
     */
    public function getConclusion()
    {
        return $this->conclusion;
    }
    /**
     * Set conclusion value
     * @param string $conclusion
     * @return \StructType\LaboratoryResearchEvent
     */
    public function setConclusion($conclusion = null)
    {
        // validation for constraint: string
        if (!is_null($conclusion) && !is_string($conclusion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conclusion)), __LINE__);
        }
        $this->conclusion = $conclusion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LaboratoryResearchEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
