<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsDate StructType
 * Meta informations extracted from the WSDL
 * - documentation: С версии 2.0 указание даты строкой (элемент informalDate) в запросах не допускается. В ответах сервиса дата строкой может
 * присутствовать для старых вет.сертификатов/записей складского журнала.
 * @subpackage Structs
 */
class GoodsDate extends AbstractStructBase
{
    /**
     * The firstDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ComplexDate
     */
    public $firstDate;
    /**
     * The secondDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ComplexDate
     */
    public $secondDate;
    /**
     * The informalDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Строковый тип с ограничением максимальной длины.
     * - maxLength: 255
     * @var string
     */
    public $informalDate;
    /**
     * Constructor method for GoodsDate
     * @uses GoodsDate::setFirstDate()
     * @uses GoodsDate::setSecondDate()
     * @uses GoodsDate::setInformalDate()
     * @param \StructType\ComplexDate $firstDate
     * @param \StructType\ComplexDate $secondDate
     * @param string $informalDate
     */
    public function __construct(\StructType\ComplexDate $firstDate = null, \StructType\ComplexDate $secondDate = null, $informalDate = null)
    {
        $this
            ->setFirstDate($firstDate)
            ->setSecondDate($secondDate)
            ->setInformalDate($informalDate);
    }
    /**
     * Get firstDate value
     * @return \StructType\ComplexDate|null
     */
    public function getFirstDate()
    {
        return $this->firstDate;
    }
    /**
     * Set firstDate value
     * @param \StructType\ComplexDate $firstDate
     * @return \StructType\GoodsDate
     */
    public function setFirstDate(\StructType\ComplexDate $firstDate = null)
    {
        $this->firstDate = $firstDate;
        return $this;
    }
    /**
     * Get secondDate value
     * @return \StructType\ComplexDate|null
     */
    public function getSecondDate()
    {
        return $this->secondDate;
    }
    /**
     * Set secondDate value
     * @param \StructType\ComplexDate $secondDate
     * @return \StructType\GoodsDate
     */
    public function setSecondDate(\StructType\ComplexDate $secondDate = null)
    {
        $this->secondDate = $secondDate;
        return $this;
    }
    /**
     * Get informalDate value
     * @return string|null
     */
    public function getInformalDate()
    {
        return $this->informalDate;
    }
    /**
     * Set informalDate value
     * @param string $informalDate
     * @return \StructType\GoodsDate
     */
    public function setInformalDate($informalDate = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($informalDate) && strlen($informalDate) > 255) || (is_array($informalDate) && count($informalDate) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($informalDate) ? strlen($informalDate) : count($informalDate)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($informalDate) && !is_string($informalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($informalDate)), __LINE__);
        }
        $this->informalDate = $informalDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GoodsDate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
