<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnterpriseNumberList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список номеров предприятий.
 * @subpackage Structs
 */
class EnterpriseNumberList extends AbstractStructBase
{
    /**
     * The enterpriseNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - documentation: Строковый тип с ограничением максимальной длины.
     * - maxLength: 255
     * @var string[]
     */
    public $enterpriseNumber;
    /**
     * Constructor method for EnterpriseNumberList
     * @uses EnterpriseNumberList::setEnterpriseNumber()
     * @param string[] $enterpriseNumber
     */
    public function __construct(array $enterpriseNumber = array())
    {
        $this
            ->setEnterpriseNumber($enterpriseNumber);
    }
    /**
     * Get enterpriseNumber value
     * @return string[]|null
     */
    public function getEnterpriseNumber()
    {
        return $this->enterpriseNumber;
    }
    /**
     * Set enterpriseNumber value
     * @throws \InvalidArgumentException
     * @param string[] $enterpriseNumber
     * @return \StructType\EnterpriseNumberList
     */
    public function setEnterpriseNumber(array $enterpriseNumber = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($enterpriseNumber) && strlen($enterpriseNumber) > 255) || (is_array($enterpriseNumber) && count($enterpriseNumber) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($enterpriseNumber) ? strlen($enterpriseNumber) : count($enterpriseNumber)), __LINE__);
        }
        foreach ($enterpriseNumber as $enterpriseNumberListEnterpriseNumberItem) {
            // validation for constraint: itemType
            if (!is_string($enterpriseNumberListEnterpriseNumberItem)) {
                throw new \InvalidArgumentException(sprintf('The enterpriseNumber property can only contain items of string, "%s" given', is_object($enterpriseNumberListEnterpriseNumberItem) ? get_class($enterpriseNumberListEnterpriseNumberItem) : gettype($enterpriseNumberListEnterpriseNumberItem)), __LINE__);
            }
        }
        $this->enterpriseNumber = $enterpriseNumber;
        return $this;
    }
    /**
     * Add item to enterpriseNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\EnterpriseNumberList
     */
    public function addToEnterpriseNumber($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 255) || (is_array($item) && count($item) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The enterpriseNumber property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->enterpriseNumber[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EnterpriseNumberList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
