<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Document StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ.
 * @subpackage Structs
 */
class Document extends GenericEntity
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Название документа. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The form
     * Meta informations extracted from the WSDL
     * - documentation: Форма документа. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $form;
    /**
     * The issueSeries
     * Meta informations extracted from the WSDL
     * - documentation: Серия документа. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $issueSeries;
    /**
     * The issueNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $issueNumber;
    /**
     * The issueDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $issueDate;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The issuer
     * Meta informations extracted from the WSDL
     * - documentation: Организация, оформившая документ.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Organization
     */
    public $issuer;
    /**
     * The for
     * Meta informations extracted from the WSDL
     * - documentation: Опциональная ссылка на связанный элемент. Например, ссылка на consignment в запросе.
     * - use: optional
     * @var string
     */
    public $for;
    /**
     * The qualifier
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: Тип, описывающий идентификатор.
     * - maxLength: 100
     * @var string
     */
    public $qualifier;
    /**
     * Constructor method for Document
     * @uses Document::setName()
     * @uses Document::setForm()
     * @uses Document::setIssueSeries()
     * @uses Document::setIssueNumber()
     * @uses Document::setIssueDate()
     * @uses Document::setType()
     * @uses Document::setIssuer()
     * @uses Document::setFor()
     * @uses Document::setQualifier()
     * @param string $name
     * @param string $form
     * @param string $issueSeries
     * @param string $issueNumber
     * @param string $issueDate
     * @param string $type
     * @param \StructType\Organization $issuer
     * @param string $for
     * @param string $qualifier
     */
    public function __construct($name = null, $form = null, $issueSeries = null, $issueNumber = null, $issueDate = null, $type = null, \StructType\Organization $issuer = null, $for = null, $qualifier = null)
    {
        $this
            ->setName($name)
            ->setForm($form)
            ->setIssueSeries($issueSeries)
            ->setIssueNumber($issueNumber)
            ->setIssueDate($issueDate)
            ->setType($type)
            ->setIssuer($issuer)
            ->setFor($for)
            ->setQualifier($qualifier);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Document
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get form value
     * @return string|null
     */
    public function getForm()
    {
        return $this->form;
    }
    /**
     * Set form value
     * @param string $form
     * @return \StructType\Document
     */
    public function setForm($form = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($form) && strlen($form) > 255) || (is_array($form) && count($form) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($form) ? strlen($form) : count($form)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($form) && !is_string($form)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($form)), __LINE__);
        }
        $this->form = $form;
        return $this;
    }
    /**
     * Get issueSeries value
     * @return string|null
     */
    public function getIssueSeries()
    {
        return $this->issueSeries;
    }
    /**
     * Set issueSeries value
     * @param string $issueSeries
     * @return \StructType\Document
     */
    public function setIssueSeries($issueSeries = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($issueSeries) && strlen($issueSeries) > 255) || (is_array($issueSeries) && count($issueSeries) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($issueSeries) ? strlen($issueSeries) : count($issueSeries)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($issueSeries) && !is_string($issueSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issueSeries)), __LINE__);
        }
        $this->issueSeries = $issueSeries;
        return $this;
    }
    /**
     * Get issueNumber value
     * @return string|null
     */
    public function getIssueNumber()
    {
        return $this->issueNumber;
    }
    /**
     * Set issueNumber value
     * @param string $issueNumber
     * @return \StructType\Document
     */
    public function setIssueNumber($issueNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($issueNumber) && strlen($issueNumber) > 255) || (is_array($issueNumber) && count($issueNumber) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($issueNumber) ? strlen($issueNumber) : count($issueNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($issueNumber) && !is_string($issueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issueNumber)), __LINE__);
        }
        $this->issueNumber = $issueNumber;
        return $this;
    }
    /**
     * Get issueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->issueDate;
    }
    /**
     * Set issueDate value
     * @param string $issueDate
     * @return \StructType\Document
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issueDate)), __LINE__);
        }
        $this->issueDate = $issueDate;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\DocumentType::valueIsValid()
     * @uses \EnumType\DocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Document
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DocumentType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\DocumentType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get issuer value
     * @return \StructType\Organization|null
     */
    public function getIssuer()
    {
        return $this->issuer;
    }
    /**
     * Set issuer value
     * @param \StructType\Organization $issuer
     * @return \StructType\Document
     */
    public function setIssuer(\StructType\Organization $issuer = null)
    {
        $this->issuer = $issuer;
        return $this;
    }
    /**
     * Get for value
     * @return string|null
     */
    public function getFor()
    {
        return $this->for;
    }
    /**
     * Set for value
     * @param string $for
     * @return \StructType\Document
     */
    public function setFor($for = null)
    {
        // validation for constraint: string
        if (!is_null($for) && !is_string($for)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($for)), __LINE__);
        }
        $this->for = $for;
        return $this;
    }
    /**
     * Get qualifier value
     * @return string|null
     */
    public function getQualifier()
    {
        return $this->qualifier;
    }
    /**
     * Set qualifier value
     * @param string $qualifier
     * @return \StructType\Document
     */
    public function setQualifier($qualifier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($qualifier) && strlen($qualifier) > 100) || (is_array($qualifier) && count($qualifier) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($qualifier) ? strlen($qualifier) : count($qualifier)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($qualifier) && !is_string($qualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($qualifier)), __LINE__);
        }
        $this->qualifier = $qualifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Document
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
