<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryFactList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о контроле партии.
 * @subpackage Structs
 */
class DeliveryFactList extends AbstractStructBase
{
    /**
     * The vetCertificatePresence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $vetCertificatePresence;
    /**
     * The docInspection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DeliveryInspection
     */
    public $docInspection;
    /**
     * The vetInspection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DeliveryInspection
     */
    public $vetInspection;
    /**
     * The decision
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $decision;
    /**
     * Constructor method for DeliveryFactList
     * @uses DeliveryFactList::setVetCertificatePresence()
     * @uses DeliveryFactList::setDocInspection()
     * @uses DeliveryFactList::setVetInspection()
     * @uses DeliveryFactList::setDecision()
     * @param string $vetCertificatePresence
     * @param \StructType\DeliveryInspection $docInspection
     * @param \StructType\DeliveryInspection $vetInspection
     * @param string $decision
     */
    public function __construct($vetCertificatePresence = null, \StructType\DeliveryInspection $docInspection = null, \StructType\DeliveryInspection $vetInspection = null, $decision = null)
    {
        $this
            ->setVetCertificatePresence($vetCertificatePresence)
            ->setDocInspection($docInspection)
            ->setVetInspection($vetInspection)
            ->setDecision($decision);
    }
    /**
     * Get vetCertificatePresence value
     * @return string
     */
    public function getVetCertificatePresence()
    {
        return $this->vetCertificatePresence;
    }
    /**
     * Set vetCertificatePresence value
     * @uses \EnumType\DocumentNature::valueIsValid()
     * @uses \EnumType\DocumentNature::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vetCertificatePresence
     * @return \StructType\DeliveryFactList
     */
    public function setVetCertificatePresence($vetCertificatePresence = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DocumentNature::valueIsValid($vetCertificatePresence)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vetCertificatePresence, implode(', ', \EnumType\DocumentNature::getValidValues())), __LINE__);
        }
        $this->vetCertificatePresence = $vetCertificatePresence;
        return $this;
    }
    /**
     * Get docInspection value
     * @return \StructType\DeliveryInspection
     */
    public function getDocInspection()
    {
        return $this->docInspection;
    }
    /**
     * Set docInspection value
     * @param \StructType\DeliveryInspection $docInspection
     * @return \StructType\DeliveryFactList
     */
    public function setDocInspection(\StructType\DeliveryInspection $docInspection = null)
    {
        $this->docInspection = $docInspection;
        return $this;
    }
    /**
     * Get vetInspection value
     * @return \StructType\DeliveryInspection
     */
    public function getVetInspection()
    {
        return $this->vetInspection;
    }
    /**
     * Set vetInspection value
     * @param \StructType\DeliveryInspection $vetInspection
     * @return \StructType\DeliveryFactList
     */
    public function setVetInspection(\StructType\DeliveryInspection $vetInspection = null)
    {
        $this->vetInspection = $vetInspection;
        return $this;
    }
    /**
     * Get decision value
     * @return string
     */
    public function getDecision()
    {
        return $this->decision;
    }
    /**
     * Set decision value
     * @uses \EnumType\DeliveryDecision::valueIsValid()
     * @uses \EnumType\DeliveryDecision::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $decision
     * @return \StructType\DeliveryFactList
     */
    public function setDecision($decision = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryDecision::valueIsValid($decision)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $decision, implode(', ', \EnumType\DeliveryDecision::getValidValues())), __LINE__);
        }
        $this->decision = $decision;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeliveryFactList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
