<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Delivery StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий поставку.
 * @subpackage Structs
 */
class Delivery extends GenericEntity
{
    /**
     * The deliveryDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deliveryDate;
    /**
     * The consignor
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об отправителе (владельце).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BusinessMember
     */
    public $consignor;
    /**
     * The consignee
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о получателе груза.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BusinessMember
     */
    public $consignee;
    /**
     * The consignment
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о транспортной партии.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Consignment[]
     */
    public $consignment;
    /**
     * The broker
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о фирме-посреднике.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BusinessEntity
     */
    public $broker;
    /**
     * The transportInfo
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о транспорте.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TransportInfo
     */
    public $transportInfo;
    /**
     * The transportStorageType
     * Meta informations extracted from the WSDL
     * - documentation: Способ хранения при перевозке.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $transportStorageType;
    /**
     * The shipmentRoute
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о маршруте следования (пунктах перегрузки).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShipmentRoute
     */
    public $shipmentRoute;
    /**
     * The accompanyingForms
     * Meta informations extracted from the WSDL
     * - documentation: Сопроводительные документы.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConsignmentDocumentList
     */
    public $accompanyingForms;
    /**
     * Constructor method for Delivery
     * @uses Delivery::setDeliveryDate()
     * @uses Delivery::setConsignor()
     * @uses Delivery::setConsignee()
     * @uses Delivery::setConsignment()
     * @uses Delivery::setBroker()
     * @uses Delivery::setTransportInfo()
     * @uses Delivery::setTransportStorageType()
     * @uses Delivery::setShipmentRoute()
     * @uses Delivery::setAccompanyingForms()
     * @param string $deliveryDate
     * @param \StructType\BusinessMember $consignor
     * @param \StructType\BusinessMember $consignee
     * @param \StructType\Consignment[] $consignment
     * @param \StructType\BusinessEntity $broker
     * @param \StructType\TransportInfo $transportInfo
     * @param string $transportStorageType
     * @param \StructType\ShipmentRoute $shipmentRoute
     * @param \StructType\ConsignmentDocumentList $accompanyingForms
     */
    public function __construct($deliveryDate = null, \StructType\BusinessMember $consignor = null, \StructType\BusinessMember $consignee = null, array $consignment = array(), \StructType\BusinessEntity $broker = null, \StructType\TransportInfo $transportInfo = null, $transportStorageType = null, \StructType\ShipmentRoute $shipmentRoute = null, \StructType\ConsignmentDocumentList $accompanyingForms = null)
    {
        $this
            ->setDeliveryDate($deliveryDate)
            ->setConsignor($consignor)
            ->setConsignee($consignee)
            ->setConsignment($consignment)
            ->setBroker($broker)
            ->setTransportInfo($transportInfo)
            ->setTransportStorageType($transportStorageType)
            ->setShipmentRoute($shipmentRoute)
            ->setAccompanyingForms($accompanyingForms);
    }
    /**
     * Get deliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->deliveryDate;
    }
    /**
     * Set deliveryDate value
     * @param string $deliveryDate
     * @return \StructType\Delivery
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryDate)), __LINE__);
        }
        $this->deliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get consignor value
     * @return \StructType\BusinessMember|null
     */
    public function getConsignor()
    {
        return $this->consignor;
    }
    /**
     * Set consignor value
     * @param \StructType\BusinessMember $consignor
     * @return \StructType\Delivery
     */
    public function setConsignor(\StructType\BusinessMember $consignor = null)
    {
        $this->consignor = $consignor;
        return $this;
    }
    /**
     * Get consignee value
     * @return \StructType\BusinessMember|null
     */
    public function getConsignee()
    {
        return $this->consignee;
    }
    /**
     * Set consignee value
     * @param \StructType\BusinessMember $consignee
     * @return \StructType\Delivery
     */
    public function setConsignee(\StructType\BusinessMember $consignee = null)
    {
        $this->consignee = $consignee;
        return $this;
    }
    /**
     * Get consignment value
     * @return \StructType\Consignment[]|null
     */
    public function getConsignment()
    {
        return $this->consignment;
    }
    /**
     * Set consignment value
     * @throws \InvalidArgumentException
     * @param \StructType\Consignment[] $consignment
     * @return \StructType\Delivery
     */
    public function setConsignment(array $consignment = array())
    {
        foreach ($consignment as $deliveryConsignmentItem) {
            // validation for constraint: itemType
            if (!$deliveryConsignmentItem instanceof \StructType\Consignment) {
                throw new \InvalidArgumentException(sprintf('The consignment property can only contain items of \StructType\Consignment, "%s" given', is_object($deliveryConsignmentItem) ? get_class($deliveryConsignmentItem) : gettype($deliveryConsignmentItem)), __LINE__);
            }
        }
        $this->consignment = $consignment;
        return $this;
    }
    /**
     * Add item to consignment value
     * @throws \InvalidArgumentException
     * @param \StructType\Consignment $item
     * @return \StructType\Delivery
     */
    public function addToConsignment(\StructType\Consignment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Consignment) {
            throw new \InvalidArgumentException(sprintf('The consignment property can only contain items of \StructType\Consignment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->consignment[] = $item;
        return $this;
    }
    /**
     * Get broker value
     * @return \StructType\BusinessEntity|null
     */
    public function getBroker()
    {
        return $this->broker;
    }
    /**
     * Set broker value
     * @param \StructType\BusinessEntity $broker
     * @return \StructType\Delivery
     */
    public function setBroker(\StructType\BusinessEntity $broker = null)
    {
        $this->broker = $broker;
        return $this;
    }
    /**
     * Get transportInfo value
     * @return \StructType\TransportInfo|null
     */
    public function getTransportInfo()
    {
        return $this->transportInfo;
    }
    /**
     * Set transportInfo value
     * @param \StructType\TransportInfo $transportInfo
     * @return \StructType\Delivery
     */
    public function setTransportInfo(\StructType\TransportInfo $transportInfo = null)
    {
        $this->transportInfo = $transportInfo;
        return $this;
    }
    /**
     * Get transportStorageType value
     * @return string|null
     */
    public function getTransportStorageType()
    {
        return $this->transportStorageType;
    }
    /**
     * Set transportStorageType value
     * @uses \EnumType\TransportationStorageType::valueIsValid()
     * @uses \EnumType\TransportationStorageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transportStorageType
     * @return \StructType\Delivery
     */
    public function setTransportStorageType($transportStorageType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransportationStorageType::valueIsValid($transportStorageType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transportStorageType, implode(', ', \EnumType\TransportationStorageType::getValidValues())), __LINE__);
        }
        $this->transportStorageType = $transportStorageType;
        return $this;
    }
    /**
     * Get shipmentRoute value
     * @return \StructType\ShipmentRoute|null
     */
    public function getShipmentRoute()
    {
        return $this->shipmentRoute;
    }
    /**
     * Set shipmentRoute value
     * @param \StructType\ShipmentRoute $shipmentRoute
     * @return \StructType\Delivery
     */
    public function setShipmentRoute(\StructType\ShipmentRoute $shipmentRoute = null)
    {
        $this->shipmentRoute = $shipmentRoute;
        return $this;
    }
    /**
     * Get accompanyingForms value
     * @return \StructType\ConsignmentDocumentList|null
     */
    public function getAccompanyingForms()
    {
        return $this->accompanyingForms;
    }
    /**
     * Set accompanyingForms value
     * @param \StructType\ConsignmentDocumentList $accompanyingForms
     * @return \StructType\Delivery
     */
    public function setAccompanyingForms(\StructType\ConsignmentDocumentList $accompanyingForms = null)
    {
        $this->accompanyingForms = $accompanyingForms;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Delivery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
