<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CountryList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип-обертка для списка стран.
 * @subpackage Structs
 */
class CountryList extends EntityList
{
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Country[]
     */
    public $country;
    /**
     * Constructor method for CountryList
     * @uses CountryList::setCountry()
     * @param \StructType\Country[] $country
     */
    public function __construct(array $country = array())
    {
        $this
            ->setCountry($country);
    }
    /**
     * Get country value
     * @return \StructType\Country[]|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @throws \InvalidArgumentException
     * @param \StructType\Country[] $country
     * @return \StructType\CountryList
     */
    public function setCountry(array $country = array())
    {
        foreach ($country as $countryListCountryItem) {
            // validation for constraint: itemType
            if (!$countryListCountryItem instanceof \StructType\Country) {
                throw new \InvalidArgumentException(sprintf('The country property can only contain items of \StructType\Country, "%s" given', is_object($countryListCountryItem) ? get_class($countryListCountryItem) : gettype($countryListCountryItem)), __LINE__);
            }
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Add item to country value
     * @throws \InvalidArgumentException
     * @param \StructType\Country $item
     * @return \StructType\CountryList
     */
    public function addToCountry(\StructType\Country $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Country) {
            throw new \InvalidArgumentException(sprintf('The country property can only contain items of \StructType\Country, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->country[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CountryList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
