<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Country StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий страну.
 * @subpackage Structs
 */
class Country extends GenericVersioningEntity
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Название страны. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The fullName
     * Meta informations extracted from the WSDL
     * - documentation: Полное название страны, если имеется. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $fullName;
    /**
     * The englishName
     * Meta informations extracted from the WSDL
     * - documentation: Английское название страны. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $englishName;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - documentation: Двухбуквенный код страны, соответствующий стандарту ISO 3166-1. В качестве кода используются буквы латинского алфавита. | Тип,
     * описывающий двухсимвольный код страны.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 2
     * @var string
     */
    public $code;
    /**
     * The code3
     * Meta informations extracted from the WSDL
     * - documentation: Трехбуквенный код страны, соответсвующий стандарту ISO 3166-1. В качестве кода используются буквы латинского алфавита. | Тип,
     * описывающий трехсимвольный код страны.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 3
     * @var string
     */
    public $code3;
    /**
     * Constructor method for Country
     * @uses Country::setName()
     * @uses Country::setFullName()
     * @uses Country::setEnglishName()
     * @uses Country::setCode()
     * @uses Country::setCode3()
     * @param string $name
     * @param string $fullName
     * @param string $englishName
     * @param string $code
     * @param string $code3
     */
    public function __construct($name = null, $fullName = null, $englishName = null, $code = null, $code3 = null)
    {
        $this
            ->setName($name)
            ->setFullName($fullName)
            ->setEnglishName($englishName)
            ->setCode($code)
            ->setCode3($code3);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Country
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get fullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->fullName;
    }
    /**
     * Set fullName value
     * @param string $fullName
     * @return \StructType\Country
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fullName) && strlen($fullName) > 255) || (is_array($fullName) && count($fullName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($fullName) ? strlen($fullName) : count($fullName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullName)), __LINE__);
        }
        $this->fullName = $fullName;
        return $this;
    }
    /**
     * Get englishName value
     * @return string|null
     */
    public function getEnglishName()
    {
        return $this->englishName;
    }
    /**
     * Set englishName value
     * @param string $englishName
     * @return \StructType\Country
     */
    public function setEnglishName($englishName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($englishName) && strlen($englishName) > 255) || (is_array($englishName) && count($englishName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($englishName) ? strlen($englishName) : count($englishName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($englishName) && !is_string($englishName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($englishName)), __LINE__);
        }
        $this->englishName = $englishName;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\Country
     */
    public function setCode($code = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($code) && strlen($code) > 2) || (is_array($code) && count($code) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($code) ? strlen($code) : count($code)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get code3 value
     * @return string|null
     */
    public function getCode3()
    {
        return $this->code3;
    }
    /**
     * Set code3 value
     * @param string $code3
     * @return \StructType\Country
     */
    public function setCode3($code3 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($code3) && strlen($code3) > 3) || (is_array($code3) && count($code3) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($code3) ? strlen($code3) : count($code3)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($code3) && !is_string($code3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code3)), __LINE__);
        }
        $this->code3 = $code3;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Country
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
