<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ComplexDate StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий дату.
 * @subpackage Structs
 */
class ComplexDate extends AbstractStructBase
{
    /**
     * The year
     * Meta informations extracted from the WSDL
     * - documentation: Год | Год
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [1-2][0-9][0-9][0-9]
     * @var int
     */
    public $year;
    /**
     * The month
     * Meta informations extracted from the WSDL
     * - documentation: Месяц | Месяц
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxInclusive: 12
     * - minInclusive: 1
     * @var int
     */
    public $month;
    /**
     * The day
     * Meta informations extracted from the WSDL
     * - documentation: День | День месяца
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxInclusive: 31
     * - minInclusive: 1
     * @var int
     */
    public $day;
    /**
     * The hour
     * Meta informations extracted from the WSDL
     * - documentation: Час | Час
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxInclusive: 23
     * - minInclusive: 0
     * @var int
     */
    public $hour;
    /**
     * The minute
     * Meta informations extracted from the WSDL
     * - documentation: Час | Минута
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxInclusive: 59
     * - minInclusive: 0
     * @var int
     */
    public $minute;
    /**
     * Constructor method for ComplexDate
     * @uses ComplexDate::setYear()
     * @uses ComplexDate::setMonth()
     * @uses ComplexDate::setDay()
     * @uses ComplexDate::setHour()
     * @uses ComplexDate::setMinute()
     * @param int $year
     * @param int $month
     * @param int $day
     * @param int $hour
     * @param int $minute
     */
    public function __construct($year = null, $month = null, $day = null, $hour = null, $minute = null)
    {
        $this
            ->setYear($year)
            ->setMonth($month)
            ->setDay($day)
            ->setHour($hour)
            ->setMinute($minute);
    }
    /**
     * Get year value
     * @return int|null
     */
    public function getYear()
    {
        return $this->year;
    }
    /**
     * Set year value
     * @param int $year
     * @return \StructType\ComplexDate
     */
    public function setYear($year = null)
    {
        // validation for constraint: pattern
        if (is_scalar($year) && !preg_match('/[1-2][0-9][0-9][0-9]/', $year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[1-2][0-9][0-9][0-9]", "%s" given', var_export($year, true)), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($year) && !is_numeric($year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($year)), __LINE__);
        }
        $this->year = $year;
        return $this;
    }
    /**
     * Get month value
     * @return int|null
     */
    public function getMonth()
    {
        return $this->month;
    }
    /**
     * Set month value
     * @param int $month
     * @return \StructType\ComplexDate
     */
    public function setMonth($month = null)
    {
        // validation for constraint: maxInclusive
        if ($month > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 12, "%s" given', $month), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($month < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $month), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($month) && !is_numeric($month)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($month)), __LINE__);
        }
        $this->month = $month;
        return $this;
    }
    /**
     * Get day value
     * @return int|null
     */
    public function getDay()
    {
        return $this->day;
    }
    /**
     * Set day value
     * @param int $day
     * @return \StructType\ComplexDate
     */
    public function setDay($day = null)
    {
        // validation for constraint: maxInclusive
        if ($day > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 31, "%s" given', $day), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($day < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $day), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($day) && !is_numeric($day)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($day)), __LINE__);
        }
        $this->day = $day;
        return $this;
    }
    /**
     * Get hour value
     * @return int|null
     */
    public function getHour()
    {
        return $this->hour;
    }
    /**
     * Set hour value
     * @param int $hour
     * @return \StructType\ComplexDate
     */
    public function setHour($hour = null)
    {
        // validation for constraint: maxInclusive
        if ($hour > 23) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 23, "%s" given', $hour), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($hour < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $hour), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($hour) && !is_numeric($hour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hour)), __LINE__);
        }
        $this->hour = $hour;
        return $this;
    }
    /**
     * Get minute value
     * @return int|null
     */
    public function getMinute()
    {
        return $this->minute;
    }
    /**
     * Set minute value
     * @param int $minute
     * @return \StructType\ComplexDate
     */
    public function setMinute($minute = null)
    {
        // validation for constraint: maxInclusive
        if ($minute > 59) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 59, "%s" given', $minute), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($minute < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $minute), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($minute) && !is_numeric($minute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minute)), __LINE__);
        }
        $this->minute = $minute;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ComplexDate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
