<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckShipmentRegionalizationResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Результат проверки правил регионализации. | Описание правил перемещения продукции. Количество элементов `r13nRouteSection` в ответе
 * соответствует количеству отрезков маршрута. Атрибут `r13nRouteSection/sqnId` равен номеру отрезка, нумерация начинается с единицы. Количество
 * элементов `r13nRouteSection/appliedR13nRule` соответствует количеству категорий груза (элемент `cargoType`) в запросе.
 * @subpackage Structs
 */
class CheckShipmentRegionalizationResponse extends ApplicationResultData
{
    /**
     * The r13nRouteSection
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: vd:r13nRouteSection
     * @var \StructType\RouteSectionR13nRules[]
     */
    public $r13nRouteSection;
    /**
     * Constructor method for CheckShipmentRegionalizationResponse
     * @uses CheckShipmentRegionalizationResponse::setR13nRouteSection()
     * @param \StructType\RouteSectionR13nRules[] $r13nRouteSection
     */
    public function __construct(array $r13nRouteSection = array())
    {
        $this
            ->setR13nRouteSection($r13nRouteSection);
    }
    /**
     * Get r13nRouteSection value
     * @return \StructType\RouteSectionR13nRules[]|null
     */
    public function getR13nRouteSection()
    {
        return $this->r13nRouteSection;
    }
    /**
     * Set r13nRouteSection value
     * @throws \InvalidArgumentException
     * @param \StructType\RouteSectionR13nRules[] $r13nRouteSection
     * @return \StructType\CheckShipmentRegionalizationResponse
     */
    public function setR13nRouteSection(array $r13nRouteSection = array())
    {
        foreach ($r13nRouteSection as $checkShipmentRegionalizationResponseR13nRouteSectionItem) {
            // validation for constraint: itemType
            if (!$checkShipmentRegionalizationResponseR13nRouteSectionItem instanceof \StructType\RouteSectionR13nRules) {
                throw new \InvalidArgumentException(sprintf('The r13nRouteSection property can only contain items of \StructType\RouteSectionR13nRules, "%s" given', is_object($checkShipmentRegionalizationResponseR13nRouteSectionItem) ? get_class($checkShipmentRegionalizationResponseR13nRouteSectionItem) : gettype($checkShipmentRegionalizationResponseR13nRouteSectionItem)), __LINE__);
            }
        }
        $this->r13nRouteSection = $r13nRouteSection;
        return $this;
    }
    /**
     * Add item to r13nRouteSection value
     * @throws \InvalidArgumentException
     * @param \StructType\RouteSectionR13nRules $item
     * @return \StructType\CheckShipmentRegionalizationResponse
     */
    public function addToR13nRouteSection(\StructType\RouteSectionR13nRules $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RouteSectionR13nRules) {
            throw new \InvalidArgumentException(sprintf('The r13nRouteSection property can only contain items of \StructType\RouteSectionR13nRules, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->r13nRouteSection[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckShipmentRegionalizationResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
