<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessEntityList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список ХС.
 * @subpackage Structs
 */
class BusinessEntityList extends EntityList
{
    /**
     * The businessEntity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BusinessEntity[]
     */
    public $businessEntity;
    /**
     * Constructor method for BusinessEntityList
     * @uses BusinessEntityList::setBusinessEntity()
     * @param \StructType\BusinessEntity[] $businessEntity
     */
    public function __construct(array $businessEntity = array())
    {
        $this
            ->setBusinessEntity($businessEntity);
    }
    /**
     * Get businessEntity value
     * @return \StructType\BusinessEntity[]|null
     */
    public function getBusinessEntity()
    {
        return $this->businessEntity;
    }
    /**
     * Set businessEntity value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessEntity[] $businessEntity
     * @return \StructType\BusinessEntityList
     */
    public function setBusinessEntity(array $businessEntity = array())
    {
        foreach ($businessEntity as $businessEntityListBusinessEntityItem) {
            // validation for constraint: itemType
            if (!$businessEntityListBusinessEntityItem instanceof \StructType\BusinessEntity) {
                throw new \InvalidArgumentException(sprintf('The businessEntity property can only contain items of \StructType\BusinessEntity, "%s" given', is_object($businessEntityListBusinessEntityItem) ? get_class($businessEntityListBusinessEntityItem) : gettype($businessEntityListBusinessEntityItem)), __LINE__);
            }
        }
        $this->businessEntity = $businessEntity;
        return $this;
    }
    /**
     * Add item to businessEntity value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessEntity $item
     * @return \StructType\BusinessEntityList
     */
    public function addToBusinessEntity(\StructType\BusinessEntity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BusinessEntity) {
            throw new \InvalidArgumentException(sprintf('The businessEntity property can only contain items of \StructType\BusinessEntity, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->businessEntity[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessEntityList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
