<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessEntity StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий ХС.
 * @subpackage Structs
 */
class BusinessEntity extends GenericVersioningEntity
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: Тип ХС
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование хозяйствующего субъекта без ОПФ. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The incorporationForm
     * Meta informations extracted from the WSDL
     * - documentation: Организационно-правовая форма.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IncorporationForm
     */
    public $incorporationForm;
    /**
     * The fullName
     * Meta informations extracted from the WSDL
     * - documentation: Полное наименование хозяйствующего субъекта. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $fullName;
    /**
     * The fio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО хозяйствующего субъекта. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $fio;
    /**
     * The passport
     * Meta informations extracted from the WSDL
     * - documentation: Паспортные данные. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $passport;
    /**
     * The inn
     * Meta informations extracted from the WSDL
     * - documentation: Идентификационный номер ХС (ИНН, БИН или ИИН). | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $inn;
    /**
     * The kpp
     * Meta informations extracted from the WSDL
     * - documentation: КПП субъекта. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $kpp;
    /**
     * The ogrn
     * Meta informations extracted from the WSDL
     * - documentation: ОГРН(ИП) субъекта. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $ogrn;
    /**
     * The juridicalAddress
     * Meta informations extracted from the WSDL
     * - documentation: Юридический адрес или адрес регистрации ХС.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $juridicalAddress;
    /**
     * The activityLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ActivityLocation[]
     */
    public $activityLocation;
    /**
     * Constructor method for BusinessEntity
     * @uses BusinessEntity::setType()
     * @uses BusinessEntity::setName()
     * @uses BusinessEntity::setIncorporationForm()
     * @uses BusinessEntity::setFullName()
     * @uses BusinessEntity::setFio()
     * @uses BusinessEntity::setPassport()
     * @uses BusinessEntity::setInn()
     * @uses BusinessEntity::setKpp()
     * @uses BusinessEntity::setOgrn()
     * @uses BusinessEntity::setJuridicalAddress()
     * @uses BusinessEntity::setActivityLocation()
     * @param string $type
     * @param string $name
     * @param \StructType\IncorporationForm $incorporationForm
     * @param string $fullName
     * @param string $fio
     * @param string $passport
     * @param string $inn
     * @param string $kpp
     * @param string $ogrn
     * @param \StructType\Address $juridicalAddress
     * @param \StructType\ActivityLocation[] $activityLocation
     */
    public function __construct($type = null, $name = null, \StructType\IncorporationForm $incorporationForm = null, $fullName = null, $fio = null, $passport = null, $inn = null, $kpp = null, $ogrn = null, \StructType\Address $juridicalAddress = null, array $activityLocation = array())
    {
        $this
            ->setType($type)
            ->setName($name)
            ->setIncorporationForm($incorporationForm)
            ->setFullName($fullName)
            ->setFio($fio)
            ->setPassport($passport)
            ->setInn($inn)
            ->setKpp($kpp)
            ->setOgrn($ogrn)
            ->setJuridicalAddress($juridicalAddress)
            ->setActivityLocation($activityLocation);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\BusinessEntityType::valueIsValid()
     * @uses \EnumType\BusinessEntityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\BusinessEntity
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusinessEntityType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\BusinessEntityType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\BusinessEntity
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get incorporationForm value
     * @return \StructType\IncorporationForm|null
     */
    public function getIncorporationForm()
    {
        return $this->incorporationForm;
    }
    /**
     * Set incorporationForm value
     * @param \StructType\IncorporationForm $incorporationForm
     * @return \StructType\BusinessEntity
     */
    public function setIncorporationForm(\StructType\IncorporationForm $incorporationForm = null)
    {
        $this->incorporationForm = $incorporationForm;
        return $this;
    }
    /**
     * Get fullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->fullName;
    }
    /**
     * Set fullName value
     * @param string $fullName
     * @return \StructType\BusinessEntity
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fullName) && strlen($fullName) > 255) || (is_array($fullName) && count($fullName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($fullName) ? strlen($fullName) : count($fullName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullName)), __LINE__);
        }
        $this->fullName = $fullName;
        return $this;
    }
    /**
     * Get fio value
     * @return string|null
     */
    public function getFio()
    {
        return $this->fio;
    }
    /**
     * Set fio value
     * @param string $fio
     * @return \StructType\BusinessEntity
     */
    public function setFio($fio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fio) && strlen($fio) > 255) || (is_array($fio) && count($fio) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($fio) ? strlen($fio) : count($fio)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fio) && !is_string($fio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fio)), __LINE__);
        }
        $this->fio = $fio;
        return $this;
    }
    /**
     * Get passport value
     * @return string|null
     */
    public function getPassport()
    {
        return $this->passport;
    }
    /**
     * Set passport value
     * @param string $passport
     * @return \StructType\BusinessEntity
     */
    public function setPassport($passport = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($passport) && strlen($passport) > 255) || (is_array($passport) && count($passport) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($passport) ? strlen($passport) : count($passport)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($passport) && !is_string($passport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passport)), __LINE__);
        }
        $this->passport = $passport;
        return $this;
    }
    /**
     * Get inn value
     * @return string|null
     */
    public function getInn()
    {
        return $this->inn;
    }
    /**
     * Set inn value
     * @param string $inn
     * @return \StructType\BusinessEntity
     */
    public function setInn($inn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($inn) && strlen($inn) > 255) || (is_array($inn) && count($inn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($inn) ? strlen($inn) : count($inn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($inn) && !is_string($inn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inn)), __LINE__);
        }
        $this->inn = $inn;
        return $this;
    }
    /**
     * Get kpp value
     * @return string|null
     */
    public function getKpp()
    {
        return $this->kpp;
    }
    /**
     * Set kpp value
     * @param string $kpp
     * @return \StructType\BusinessEntity
     */
    public function setKpp($kpp = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($kpp) && strlen($kpp) > 255) || (is_array($kpp) && count($kpp) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($kpp) ? strlen($kpp) : count($kpp)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kpp) && !is_string($kpp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kpp)), __LINE__);
        }
        $this->kpp = $kpp;
        return $this;
    }
    /**
     * Get ogrn value
     * @return string|null
     */
    public function getOgrn()
    {
        return $this->ogrn;
    }
    /**
     * Set ogrn value
     * @param string $ogrn
     * @return \StructType\BusinessEntity
     */
    public function setOgrn($ogrn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ogrn) && strlen($ogrn) > 255) || (is_array($ogrn) && count($ogrn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($ogrn) ? strlen($ogrn) : count($ogrn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ogrn) && !is_string($ogrn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ogrn)), __LINE__);
        }
        $this->ogrn = $ogrn;
        return $this;
    }
    /**
     * Get juridicalAddress value
     * @return \StructType\Address|null
     */
    public function getJuridicalAddress()
    {
        return $this->juridicalAddress;
    }
    /**
     * Set juridicalAddress value
     * @param \StructType\Address $juridicalAddress
     * @return \StructType\BusinessEntity
     */
    public function setJuridicalAddress(\StructType\Address $juridicalAddress = null)
    {
        $this->juridicalAddress = $juridicalAddress;
        return $this;
    }
    /**
     * Get activityLocation value
     * @return \StructType\ActivityLocation[]|null
     */
    public function getActivityLocation()
    {
        return $this->activityLocation;
    }
    /**
     * Set activityLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityLocation[] $activityLocation
     * @return \StructType\BusinessEntity
     */
    public function setActivityLocation(array $activityLocation = array())
    {
        foreach ($activityLocation as $businessEntityActivityLocationItem) {
            // validation for constraint: itemType
            if (!$businessEntityActivityLocationItem instanceof \StructType\ActivityLocation) {
                throw new \InvalidArgumentException(sprintf('The activityLocation property can only contain items of \StructType\ActivityLocation, "%s" given', is_object($businessEntityActivityLocationItem) ? get_class($businessEntityActivityLocationItem) : gettype($businessEntityActivityLocationItem)), __LINE__);
            }
        }
        $this->activityLocation = $activityLocation;
        return $this;
    }
    /**
     * Add item to activityLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityLocation $item
     * @return \StructType\BusinessEntity
     */
    public function addToActivityLocation(\StructType\ActivityLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityLocation) {
            throw new \InvalidArgumentException(sprintf('The activityLocation property can only contain items of \StructType\ActivityLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->activityLocation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
